/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.domain.Item;
import com.taobao.api.domain.Sku;
import com.taobao.api.request.ItemSkusGetRequest;
import com.taobao.api.request.ItemsOnsaleGetRequest;
import com.taobao.api.response.ItemSkusGetResponse;
import com.taobao.api.response.ItemsOnsaleGetResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.domain.TaoGoods;
import tech.qihangec.open.tao.domain.TaoGoodsSku;

public class GoodsApiHelper {
    private static Logger log = LoggerFactory.getLogger(GoodsApiHelper.class);
    private static final String LIST_FIELDS = "approve_status,num_iid,title,nick,type,cid,pic_url,num,props,props_name,valid_thru,list_time,price,has_discount,has_invoice,has_warranty,has_showcase,modified,delist_time,postage_id,seller_cids,outer_id,sold_quantity,skus";

    protected static ApiResultVo<TaoGoods> pullGoods(Long pageNo, Long pageSize, String url, String appKey, String appSecret, String sessionKey) throws ApiException {
        log.info("=======\u5f00\u59cb\u5168\u91cf\u5546\u54c1\u6570\u636e{}=========", (Object)LocalDateTime.now());
        DefaultTaobaoClient client = new DefaultTaobaoClient(url, appKey, appSecret);
        ItemsOnsaleGetRequest req = new ItemsOnsaleGetRequest();
        req.setFields(LIST_FIELDS);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        ItemsOnsaleGetResponse rsp = (ItemsOnsaleGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        if (rsp.getItems() == null) {
            return ApiResultVo.success(0, new ArrayList());
        }
        ArrayList<TaoGoods> goodsList = new ArrayList<TaoGoods>();
        for (Item item : rsp.getItems()) {
            TaoGoods goods = new TaoGoods();
            goods.setNumIid(item.getNumIid());
            goods.setTitle(item.getTitle());
            goods.setNick(item.getNick());
            goods.setType(item.getType());
            goods.setCid(item.getCid());
            goods.setSellerCids(item.getSellerCids());
            goods.setPicUrl(item.getPicUrl());
            goods.setNum(item.getNum().intValue());
            goods.setValidThru(item.getValidThru().intValue());
            goods.setHasDiscount("" + item.getHasDiscount());
            goods.setHasInvoice("" + item.getHasInvoice());
            goods.setHasWarranty("" + item.getHasWarranty());
            goods.setHasShowcase("" + item.getHasShowcase());
            goods.setModified(item.getModified());
            goods.setCreateTime(item.getCreated());
            goods.setDelistTime(item.getDelistTime());
            goods.setPostageId(item.getPostageId() != null ? item.getPostageId().intValue() : 0);
            goods.setOuterId(item.getOuterId());
            goods.setListTime(item.getListTime());
            goods.setPrice(item.getPrice());
            goods.setSoldQuantity(item.getSoldQuantity() == null ? 0 : item.getSoldQuantity().intValue());
            goods.setFirstStartsTime(item.getFirstStartsTime());
            goods.setSkus(GoodsApiHelper.pullSku((TaobaoClient)client, sessionKey, item.getNumIid()));
            goodsList.add(goods);
        }
        return ApiResultVo.success(rsp.getTotalResults().intValue(), goodsList);
    }

    private static List<TaoGoodsSku> pullSku(TaobaoClient client, String sessionKey, Long numIid) {
        try {
            ArrayList<TaoGoodsSku> skus = new ArrayList<TaoGoodsSku>();
            ItemSkusGetRequest req1 = new ItemSkusGetRequest();
            req1.setFields("sku_id,num_iid,properties,properties_name,quantity,price,outer_id,created,modified,status,sku_spec_id,barcode");
            req1.setNumIids("" + numIid);
            ItemSkusGetResponse rsp1 = (ItemSkusGetResponse)client.execute((TaobaoRequest)req1, sessionKey);
            if (rsp1.getSkus() != null) {
                for (Sku s : rsp1.getSkus()) {
                    TaoGoodsSku sku = new TaoGoodsSku();
                    sku.setNumIid(s.getNumIid());
                    sku.setSkuId(s.getSkuId());
                    sku.setProperties(s.getProperties());
                    sku.setPropertiesName(s.getPropertiesName());
                    sku.setQuantity(s.getQuantity());
                    sku.setPrice(StringUtils.isEmpty(s.getPrice()) ? 0.0 : Double.parseDouble(s.getPrice()));
                    sku.setOuterId(s.getOuterId());
                    sku.setStatus(s.getStatus());
                    sku.setCreated(s.getCreated());
                    sku.setModified(s.getModified());
                    skus.add(sku);
                }
                return skus;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

