/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import com.taobao.api.domain.Order;
import com.taobao.api.domain.Trade;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.qihangec.open.tao.domain.TaoOrder;
import tech.qihangec.open.tao.domain.TaoOrderItem;

public class OrderAssembleHelper {
    private static Logger log = LoggerFactory.getLogger(OrderAssembleHelper.class);

    public static TaoOrder assembleOrder(Trade trade) {
        try {
            TaoOrder order = new TaoOrder();
            order.setTid(trade.getTid().toString());
            order.setTitle(trade.getTitle());
            order.setType(trade.getType());
            order.setSellerFlag("" + trade.getSellerFlag());
            order.setHasBuyerMessage("" + trade.getHasBuyerMessage());
            order.setCreditCardFee(trade.getCreditCardFee());
            order.setCreated(trade.getCreated());
            order.setModified(trade.getModified());
            order.setPayTime(trade.getPayTime());
            order.setTotalFee(Double.parseDouble(trade.getTotalFee()));
            order.setAdjustFee(Double.parseDouble(trade.getAdjustFee()));
            order.setPostFee(BigDecimal.valueOf(Double.parseDouble(trade.getPostFee())));
            order.setDiscountFee(BigDecimal.valueOf(Double.parseDouble(trade.getDiscountFee())));
            order.setPayment(BigDecimal.valueOf(Double.parseDouble(trade.getPayment())));
            order.setReceivedPayment(BigDecimal.valueOf(Double.parseDouble(trade.getReceivedPayment())));
            order.setBuyerNick(trade.getBuyerNick());
            order.setBuyerOpenUid(trade.getBuyerOpenUid());
            order.setAlipayNo(trade.getAlipayNo());
            order.setBuyerAlipayNo(trade.getBuyerAlipayNo());
            order.setBuyerEmail(trade.getBuyerEmail());
            order.setBuyerMemo(trade.getBuyerMemo());
            order.setBuyerMessage(trade.getBuyerMessage());
            order.setMarkDesc(trade.getMarkDesc());
            order.setSellerMemo(trade.getSellerMemo());
            order.setReceiverCountry(trade.getReceiverCountry());
            order.setReceiverState(trade.getReceiverState());
            order.setReceiverCity(trade.getReceiverCity());
            order.setReceiverDistrict(trade.getReceiverDistrict());
            order.setReceiverTown(trade.getReceiverTown());
            order.setReceiverAddress(trade.getReceiverAddress());
            order.setReceiverName(trade.getReceiverName());
            order.setReceiverMobile(trade.getReceiverMobile());
            order.setReceiverPhone(trade.getReceiverPhone());
            order.setSid(trade.getSid());
            order.setYfxFee(trade.getYfxFee());
            order.setHasYfx("" + trade.getHasYfx());
            order.setStatus(trade.getStatus());
            order.setConsignTime(trade.getConsignTime());
            order.setEndTime(trade.getEndTime());
            order.setOaid(trade.getOaid());
            ArrayList<TaoOrderItem> items = new ArrayList<TaoOrderItem>();
            for (Order item : trade.getOrders()) {
                TaoOrderItem orderItem = new TaoOrderItem();
                orderItem.setTitle(item.getTitle());
                orderItem.setTid(trade.getTid());
                orderItem.setOid(item.getOid());
                orderItem.setTotalFee(StringUtils.isNotEmpty(item.getTotalFee()) ? BigDecimal.valueOf(Double.parseDouble(item.getTotalFee())) : BigDecimal.valueOf(0L));
                orderItem.setDiscountFee(StringUtils.isNotEmpty(item.getDiscountFee()) ? BigDecimal.valueOf(Double.parseDouble(item.getDiscountFee())) : BigDecimal.valueOf(0L));
                orderItem.setAdjustFee(StringUtils.isNotEmpty(item.getAdjustFee()) ? BigDecimal.valueOf(Double.parseDouble(item.getAdjustFee())) : BigDecimal.valueOf(0L));
                orderItem.setDivideOrderFee(StringUtils.isNotEmpty(item.getDivideOrderFee()) ? Double.parseDouble(item.getDivideOrderFee()) : 0.0);
                orderItem.setPartMjzDiscount(StringUtils.isNotEmpty(item.getPartMjzDiscount()) ? Double.parseDouble(item.getPartMjzDiscount()) : 0.0);
                orderItem.setPayment(StringUtils.isNotEmpty(item.getPayment()) ? Double.parseDouble(item.getPayment()) : 0.0);
                orderItem.setPrice(StringUtils.isNotEmpty(item.getPrice()) ? BigDecimal.valueOf(Double.parseDouble(item.getPrice())) : BigDecimal.valueOf(0L));
                orderItem.setPicPath(item.getPicPath());
                orderItem.setNumIid(item.getNumIid());
                orderItem.setSkuId(item.getSkuId());
                orderItem.setOuterIid(item.getOuterIid());
                orderItem.setOuterSkuId(item.getOuterSkuId());
                orderItem.setSkuPropertiesName(item.getSkuPropertiesName());
                orderItem.setItemMealId((String)(item.getItemMealId() == null ? "" : "" + item.getItemMealId()));
                orderItem.setItemMealName(item.getItemMealName());
                orderItem.setNum(item.getNum().intValue());
                orderItem.setRefundStatus(item.getRefundStatus());
                orderItem.setStatus(item.getStatus());
                orderItem.setBuyerRate("" + item.getBuyerRate());
                orderItem.setSellerRate("" + item.getSellerRate());
                orderItem.setRefundId(item.getRefundId());
                orderItem.setSellerType(item.getSellerType());
                orderItem.setCid(item.getCid());
                orderItem.setEndTime(item.getEndTime());
                try {
                    if (StringUtils.isNotEmpty(item.getConsignTime())) {
                        orderItem.setConsignTime(DateUtils.parseDate(item.getConsignTime(), "yyyy-MM-dd HH:mm:ss"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                orderItem.setShippingType(item.getShippingType());
                orderItem.setLogisticsCompany(item.getLogisticsCompany());
                orderItem.setInvoiceNo(item.getInvoiceNo());
                items.add(orderItem);
            }
            order.setItems(items);
            return order;
        }
        catch (Exception e) {
            log.error("TaoOrder\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff01" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

