/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.qihangec.open.tao.GoodsApiHelper;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.domain.TaoGoods;
import tech.qihangec.open.tao.service.TaoGoodsService;

@Service
public class TaoGoodsApiService {
    private static Logger log = LoggerFactory.getLogger(TaoGoodsApiService.class);
    private final TaoGoodsService goodsService;

    public ApiResultVo<TaoGoods> pullGoodsList(Integer shopId, String serverUrl, String appKey, String appSecret, String sessionKey) throws Exception {
        Serializable goods2;
        Long pageIndex = 1L;
        Long pageSize = 100L;
        ApiResultVo<TaoGoods> listApiResult = GoodsApiHelper.pullGoods(pageIndex, pageSize, serverUrl, appKey, appSecret, sessionKey);
        ArrayList<TaoGoods> list = new ArrayList<TaoGoods>();
        int insertSuccess = 0;
        int totalError = 0;
        int hasExistOrder = 0;
        for (Serializable goods2 : listApiResult.getList()) {
            int result = this.goodsService.saveAndUpdateGoods(shopId, (TaoGoods)goods2);
            if (result == ApiResultVoEnum.DataExist.getIndex()) {
                list.add((TaoGoods)goods2);
                ++hasExistOrder;
                continue;
            }
            if (result == ApiResultVoEnum.SUCCESS.getIndex()) {
                list.add((TaoGoods)goods2);
                ++insertSuccess;
                continue;
            }
            ++totalError;
        }
        int totalPage = (long)listApiResult.getTotalRecords().intValue() % pageSize == 0L ? listApiResult.getTotalRecords() / pageSize.intValue() : listApiResult.getTotalRecords() / pageSize.intValue() + 1;
        goods2 = pageIndex;
        pageIndex = pageIndex + 1L;
        while (pageIndex <= (long)totalPage) {
            ApiResultVo<TaoGoods> result1 = GoodsApiHelper.pullGoods(pageIndex, pageIndex, serverUrl, appKey, appSecret, sessionKey);
            for (TaoGoods goods3 : listApiResult.getList()) {
                int result = this.goodsService.saveAndUpdateGoods(shopId, goods3);
                if (result == ApiResultVoEnum.DataExist.getIndex()) {
                    list.add(goods3);
                    ++hasExistOrder;
                    continue;
                }
                if (result == ApiResultVoEnum.SUCCESS.getIndex()) {
                    list.add(goods3);
                    ++insertSuccess;
                    continue;
                }
                ++totalError;
            }
            Long l = pageIndex;
            pageIndex = pageIndex + 1L;
        }
        String msg = "\u6210\u529f\uff0c\u603b\u5171\u627e\u5230\uff1a" + listApiResult.getTotalRecords() + "\u6761\u5546\u54c1\u6570\u636e\uff0c\u65b0\u589e\uff1a" + insertSuccess + "\u6761\uff0c\u6dfb\u52a0\u9519\u8bef\uff1a" + totalError + "\u6761\uff0c\u66f4\u65b0\uff1a" + hasExistOrder + "\u6761";
        log.info(msg);
        return ApiResultVo.success(list.size(), list);
    }

    public TaoGoodsApiService(TaoGoodsService goodsService) {
        this.goodsService = goodsService;
    }
}

