/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.common.PageQuery;
import tech.qihangec.open.tao.common.PageResult;
import tech.qihangec.open.tao.domain.TaoGoods;
import tech.qihangec.open.tao.domain.TaoGoodsSku;
import tech.qihangec.open.tao.mapper.TaoGoodsMapper;
import tech.qihangec.open.tao.mapper.TaoGoodsSkuMapper;
import tech.qihangec.open.tao.service.TaoGoodsService;

@Service
public class TaoGoodsServiceImpl
extends ServiceImpl<TaoGoodsMapper, TaoGoods>
implements TaoGoodsService {
    private final TaoGoodsMapper mapper;
    private final TaoGoodsSkuMapper skuMapper;

    @Override
    public PageResult<TaoGoods> queryPageList(TaoGoods bo, PageQuery pageQuery) throws Exception {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(bo.getShopId() != null, TaoGoods::getShopId, (Object)bo.getShopId());
        Page taoGoodsPage = (Page)this.mapper.selectPage((IPage)pageQuery.build(), (Wrapper)queryWrapper);
        return PageResult.build(taoGoodsPage);
    }

    @Override
    @Transactional
    public int saveAndUpdateGoods(Integer shopId, TaoGoods goods) {
        List goodsList = this.mapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TaoGoods::getNumIid, (Object)goods.getNumIid()));
        if (goodsList != null && goodsList.size() > 0) {
            goods.setShopId(shopId);
            goods.setId(((TaoGoods)goodsList.get(0)).getId());
            this.mapper.updateById(goods);
            this.skuMapper.delete((Wrapper)new LambdaQueryWrapper().eq(TaoGoodsSku::getTaoGoodsId, (Object)goods.getId()));
            if (goods.getSkus() != null) {
                for (TaoGoodsSku sku : goods.getSkus()) {
                    sku.setTaoGoodsId(goods.getId());
                    this.skuMapper.insert(sku);
                }
            }
            return ApiResultVoEnum.DataExist.getIndex();
        }
        goods.setShopId(shopId);
        goods.setCreateTime(new Date());
        this.mapper.insert(goods);
        if (goods.getSkus() != null) {
            for (TaoGoodsSku sku : goods.getSkus()) {
                sku.setTaoGoodsId(goods.getId());
                this.skuMapper.insert(sku);
            }
        }
        return 0;
    }

    public TaoGoodsServiceImpl(TaoGoodsMapper mapper, TaoGoodsSkuMapper skuMapper) {
        this.mapper = mapper;
        this.skuMapper = skuMapper;
    }
}

