package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtAftersalesRefundRawrefundSearchhistoryResponse;

/**
 * TOP API(QimenCloud): wdt.aftersales.refund.rawrefund.searchhistory request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.12
 */
public class WdtAftersalesRefundRawrefundSearchhistoryRequest extends BaseTaobaoRequest<WdtAftersalesRefundRawrefundSearchhistoryResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页信息
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.aftersales.refund.rawrefund.searchhistory";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtAftersalesRefundRawrefundSearchhistoryResponse> getResponseClass() {
		return WdtAftersalesRefundRawrefundSearchhistoryResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 明细掩码
		 */
		@ApiField("detail_mask")
		private Long detailMask;
		/**
		 * 结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 平台id
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 原始退款单号
		 */
		@ApiField("refund_no")
		private String refundNo;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 开始时间
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 时间条件类型
		 */
		@ApiField("time_type")
		private Long timeType;
	

	public Long getDetailMask() {
			return this.detailMask;
		}
		public void setDetailMask(Long detailMask) {
			this.detailMask = detailMask;
		}
		public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public String getRefundNo() {
			return this.refundNo;
		}
		public void setRefundNo(String refundNo) {
			this.refundNo = refundNo;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public Long getTimeType() {
			return this.timeType;
		}
		public void setTimeType(Long timeType) {
			this.timeType = timeType;
		}

}

	/**
 * 分页信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}