package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtAftersalesRefundRefundSearchResponse;

/**
 * TOP API(QimenCloud): wdt.aftersales.refund.refund.search request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.24
 */
public class WdtAftersalesRefundRefundSearchRequest extends BaseTaobaoRequest<WdtAftersalesRefundRefundSearchResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.aftersales.refund.refund.search";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtAftersalesRefundRefundSearchResponse> getResponseClass() {
		return WdtAftersalesRefundRefundSearchResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 审核起始时间
		 */
		@ApiField("agree_from")
		private String agreeFrom;
		/**
		 * 审核结束时间
		 */
		@ApiField("agree_to")
		private String agreeTo;
		/**
		 * 客户网名
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 模糊查询
		 */
		@ApiField("fuzzy_query")
		private Boolean fuzzyQuery;
		/**
		 * 修改时间起始
		 */
		@ApiField("modified_from")
		private String modifiedFrom;
		/**
		 * 修改时间结束
		 */
		@ApiField("modified_to")
		private String modifiedTo;
		/**
		 * 是否拒收
		 */
		@ApiField("refund_mask_reject_return")
		private Boolean refundMaskRejectReturn;
		/**
		 * 退换单号
		 */
		@ApiField("refund_no")
		private String refundNo;
		/**
		 * 退回物流单号
		 */
		@ApiField("return_logistics_no")
		private String returnLogisticsNo;
		/**
		 * 是否为拦截件
		 */
		@ApiField("return_mask_manual_intercept")
		private Boolean returnMaskManualIntercept;
		/**
		 * 退回仓库编号
		 */
		@ApiField("return_warehouse_nos")
		private String returnWarehouseNos;
		/**
		 * 开始时间（结算时间）
		 */
		@ApiField("settle_from")
		private String settleFrom;
		/**
		 * 结束时间（结算时间）
		 */
		@ApiField("settle_to")
		private String settleTo;
		/**
		 * 店铺编号 由英文逗号分隔的店铺编号
		 */
		@ApiField("shop_nos")
		private String shopNos;
		/**
		 * 退换单状态 10:已取消;20:待审核;30:已审核;80:已结算;85:待过账;86:已过账;87:成本确认;90:已完成
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 入库状态 0:未入库;1:待入库;2:部分入库;3:全部入库;4:终止入库
		 */
		@ApiField("stockin_status")
		private Long stockinStatus;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 系统订单编号
		 */
		@ApiField("trade_no")
		private String tradeNo;
		/**
		 * 退换单类型 1:退款;2:退货;3:换货;4:退款不退货
		 */
		@ApiField("type")
		private Long type;
	

	public String getAgreeFrom() {
			return this.agreeFrom;
		}
		public void setAgreeFrom(String agreeFrom) {
			this.agreeFrom = agreeFrom;
		}
		public String getAgreeTo() {
			return this.agreeTo;
		}
		public void setAgreeTo(String agreeTo) {
			this.agreeTo = agreeTo;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public Boolean getFuzzyQuery() {
			return this.fuzzyQuery;
		}
		public void setFuzzyQuery(Boolean fuzzyQuery) {
			this.fuzzyQuery = fuzzyQuery;
		}
		public String getModifiedFrom() {
			return this.modifiedFrom;
		}
		public void setModifiedFrom(String modifiedFrom) {
			this.modifiedFrom = modifiedFrom;
		}
		public String getModifiedTo() {
			return this.modifiedTo;
		}
		public void setModifiedTo(String modifiedTo) {
			this.modifiedTo = modifiedTo;
		}
		public Boolean getRefundMaskRejectReturn() {
			return this.refundMaskRejectReturn;
		}
		public void setRefundMaskRejectReturn(Boolean refundMaskRejectReturn) {
			this.refundMaskRejectReturn = refundMaskRejectReturn;
		}
		public String getRefundNo() {
			return this.refundNo;
		}
		public void setRefundNo(String refundNo) {
			this.refundNo = refundNo;
		}
		public String getReturnLogisticsNo() {
			return this.returnLogisticsNo;
		}
		public void setReturnLogisticsNo(String returnLogisticsNo) {
			this.returnLogisticsNo = returnLogisticsNo;
		}
		public Boolean getReturnMaskManualIntercept() {
			return this.returnMaskManualIntercept;
		}
		public void setReturnMaskManualIntercept(Boolean returnMaskManualIntercept) {
			this.returnMaskManualIntercept = returnMaskManualIntercept;
		}
		public String getReturnWarehouseNos() {
			return this.returnWarehouseNos;
		}
		public void setReturnWarehouseNos(String returnWarehouseNos) {
			this.returnWarehouseNos = returnWarehouseNos;
		}
		public String getSettleFrom() {
			return this.settleFrom;
		}
		public void setSettleFrom(String settleFrom) {
			this.settleFrom = settleFrom;
		}
		public String getSettleTo() {
			return this.settleTo;
		}
		public void setSettleTo(String settleTo) {
			this.settleTo = settleTo;
		}
		public String getShopNos() {
			return this.shopNos;
		}
		public void setShopNos(String shopNos) {
			this.shopNos = shopNos;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStockinStatus() {
			return this.stockinStatus;
		}
		public void setStockinStatus(Long stockinStatus) {
			this.stockinStatus = stockinStatus;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getTradeNo() {
			return this.tradeNo;
		}
		public void setTradeNo(String tradeNo) {
			this.tradeNo = tradeNo;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}

}

	/**
 * 分页
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号从0开始
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}