package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsOuterOuteroutCreateorderResponse;

/**
 * TOP API(QimenCloud): wdt.wms.outer.outerout.createorder request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.12
 */
public class WdtWmsOuterOuteroutCreateorderRequest extends BaseTaobaoRequest<WdtWmsOuterOuteroutCreateorderResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 是否审核
	 */
	private Boolean isCheck;

	/** 
	* 单据数据
	 */
	private String order;

	/** 
	* 单据明细
	 */
	private String orderDetails;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public Boolean getIsCheck() {
		return this.isCheck;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public void setOrder(Order order) {
		this.order = new JSONWriter(false,false,true).write(order);
	}

	public String getOrder() {
		return this.order;
	}

	public void setOrderDetails(String orderDetails) {
		this.orderDetails = orderDetails;
	}

	public void setOrderDetails(List<Orderdetails> orderDetails) {
		this.orderDetails = new JSONWriter(false,false,true).write(orderDetails);
	}

	public String getOrderDetails() {
		return this.orderDetails;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.outer.outerout.createorder";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("is_check", this.isCheck);
		txtParams.put("order", this.order);
		txtParams.put("order_details", this.orderDetails);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsOuterOuteroutCreateorderResponse> getResponseClass() {
		return WdtWmsOuterOuteroutCreateorderResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(orderDetails, 999999, "orderDetails");
     }
     
	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 外部单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 出库原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 源单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 源单号类型
		 */
		@ApiField("src_order_type")
		private Long srcOrderType;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public Long getSrcOrderType() {
			return this.srcOrderType;
		}
		public void setSrcOrderType(Long srcOrderType) {
			this.srcOrderType = srcOrderType;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("orderdetails")
public static class Orderdetails {

	/**
		 * 辅助单位
		 */
		@ApiField("aux_unit_name")
		private String auxUnitName;
		/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 数量
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
	

	public String getAuxUnitName() {
			return this.auxUnitName;
		}
		public void setAuxUnitName(String auxUnitName) {
			this.auxUnitName = auxUnitName;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}

}



}