package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockPushstockdetailResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stock.pushstockdetail request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.21
 */
public class WdtWmsStockPushstockdetailRequest extends BaseTaobaoRequest<WdtWmsStockPushstockdetailResponse> {
     
     

	/** 
	* datetime
	 */
	private String datetime;

	/** 
	* 出入库明细
	 */
	private String stockDetails;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* wdt_sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setStockDetails(String stockDetails) {
		this.stockDetails = stockDetails;
	}

	public void setStockDetails(List<StockDetails> stockDetails) {
		this.stockDetails = new JSONWriter(false,false,true).write(stockDetails);
	}

	public String getStockDetails() {
		return this.stockDetails;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stock.pushstockdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("stock_details", this.stockDetails);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockPushstockdetailResponse> getResponseClass() {
		return WdtWmsStockPushstockdetailResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(stockDetails, 999999, "stockDetails");
     }
     
	/**
 * 出入库明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("stockDetails")
public static class StockDetails {

	/**
		 * 库存
		 */
		@ApiField("end_stock")
		private String endStock;
		/**
		 * 系统类型
		 */
		@ApiField("erp_type")
		private Long erpType;
		/**
		 * 扩展json
		 */
		@ApiField("json_string")
		private String jsonString;
		/**
		 * 变动数量
		 */
		@ApiField("out_num")
		private String outNum;
		/**
		 * 出入库单号
		 */
		@ApiField("out_order_no")
		private String outOrderNo;
		/**
		 * 外部商家编码
		 */
		@ApiField("out_spec_no")
		private String outSpecNo;
		/**
		 * 菜鸟仓单号
		 */
		@ApiField("pt_order_no")
		private String ptOrderNo;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 库存变动时间
		 */
		@ApiField("stock_time")
		private String stockTime;
		/**
		 * 出入库类型
		 */
		@ApiField("type")
		private Long type;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getEndStock() {
			return this.endStock;
		}
		public void setEndStock(String endStock) {
			this.endStock = endStock;
		}
		public Long getErpType() {
			return this.erpType;
		}
		public void setErpType(Long erpType) {
			this.erpType = erpType;
		}
		public String getJsonString() {
			return this.jsonString;
		}
		public void setJsonString(String jsonString) {
			this.jsonString = jsonString;
		}
		public String getOutNum() {
			return this.outNum;
		}
		public void setOutNum(String outNum) {
			this.outNum = outNum;
		}
		public String getOutOrderNo() {
			return this.outOrderNo;
		}
		public void setOutOrderNo(String outOrderNo) {
			this.outOrderNo = outOrderNo;
		}
		public String getOutSpecNo() {
			return this.outSpecNo;
		}
		public void setOutSpecNo(String outSpecNo) {
			this.outSpecNo = outSpecNo;
		}
		public String getPtOrderNo() {
			return this.ptOrderNo;
		}
		public void setPtOrderNo(String ptOrderNo) {
			this.ptOrderNo = ptOrderNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getStockTime() {
			return this.stockTime;
		}
		public void setStockTime(String stockTime) {
			this.stockTime = stockTime;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}



}