package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinPrestockinCreateextResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.prestockin.createext request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.16
 */
public class WdtWmsStockinPrestockinCreateextRequest extends BaseTaobaoRequest<WdtWmsStockinPrestockinCreateextResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 入库单明细
	 */
	private String specList;

	/** 
	* 入库单信息
	 */
	private String stockinOrder;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setSpecList(String specList) {
		this.specList = specList;
	}

	public void setSpecList(List<SpecList> specList) {
		this.specList = new JSONWriter(false,false,true).write(specList);
	}

	public String getSpecList() {
		return this.specList;
	}

	public void setStockinOrder(String stockinOrder) {
		this.stockinOrder = stockinOrder;
	}

	public void setStockinOrder(StockinOrder stockinOrder) {
		this.stockinOrder = new JSONWriter(false,false,true).write(stockinOrder);
	}

	public String getStockinOrder() {
		return this.stockinOrder;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.prestockin.createext";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("specList", this.specList);
		txtParams.put("stockinOrder", this.stockinOrder);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinPrestockinCreateextResponse> getResponseClass() {
		return WdtWmsStockinPrestockinCreateextResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(specList, 999999, "specList");
     }
     
	/**
 * 入库单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class StockinOrder {

	/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 入库单号
		 */
		@ApiField("stockin_no")
		private String stockinNo;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getStockinNo() {
			return this.stockinNo;
		}
		public void setStockinNo(String stockinNo) {
			this.stockinNo = stockinNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 入库单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("specList")
public static class SpecList {

	/**
		 * 残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
	

	public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}

}



}