package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinPurchaseUploadResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.purchase.upload request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.22
 */
public class WdtWmsStockinPurchaseUploadRequest extends BaseTaobaoRequest<WdtWmsStockinPurchaseUploadResponse> {
     
     

	/** 
	* 时间戳
	 */
	private String datetime;

	/** 
	* 是否提交
	 */
	private Boolean isSubmit;

	/** 
	* 入库单明细
	 */
	private String stockinDetailList;

	/** 
	* 入库单单据信息
	 */
	private String stockinOrder;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setIsSubmit(Boolean isSubmit) {
		this.isSubmit = isSubmit;
	}

	public Boolean getIsSubmit() {
		return this.isSubmit;
	}

	public void setStockinDetailList(String stockinDetailList) {
		this.stockinDetailList = stockinDetailList;
	}

	public void setStockinDetailList(List<StockinDetailList> stockinDetailList) {
		this.stockinDetailList = new JSONWriter(false,false,true).write(stockinDetailList);
	}

	public String getStockinDetailList() {
		return this.stockinDetailList;
	}

	public void setStockinOrder(String stockinOrder) {
		this.stockinOrder = stockinOrder;
	}

	public void setStockinOrder(StockinOrder stockinOrder) {
		this.stockinOrder = new JSONWriter(false,false,true).write(stockinOrder);
	}

	public String getStockinOrder() {
		return this.stockinOrder;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.purchase.upload";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("is_submit", this.isSubmit);
		txtParams.put("stockin_detail_list", this.stockinDetailList);
		txtParams.put("stockin_order", this.stockinOrder);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinPurchaseUploadResponse> getResponseClass() {
		return WdtWmsStockinPurchaseUploadResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(stockinDetailList, 999999, "stockinDetailList");
     }
     
	/**
 * 入库单单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class StockinOrder {

	/**
		 * 创建模式
		 */
		@ApiField("create_mode")
		private Long createMode;
		/**
		 * 物流编码,系统内自定义物流的编码
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 采购单号
		 */
		@ApiField("purchase_no")
		private String purchaseNo;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * sn码
		 */
		@ApiField("sn_strings")
		private String snStrings;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public Long getCreateMode() {
			return this.createMode;
		}
		public void setCreateMode(Long createMode) {
			this.createMode = createMode;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getPurchaseNo() {
			return this.purchaseNo;
		}
		public void setPurchaseNo(String purchaseNo) {
			this.purchaseNo = purchaseNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSnStrings() {
			return this.snStrings;
		}
		public void setSnStrings(String snStrings) {
			this.snStrings = snStrings;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 入库单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("stockinDetailList")
public static class StockinDetailList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 生产日期
		 */
		@ApiField("production_date")
		private String productionDate;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 采购单位
		 */
		@ApiField("unit_name")
		private String unitName;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getProductionDate() {
			return this.productionDate;
		}
		public void setProductionDate(String productionDate) {
			this.productionDate = productionDate;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}

}



}