package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinRefundQuerywithdetailResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.refund.querywithdetail request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.04
 */
public class WdtWmsStockinRefundQuerywithdetailRequest extends BaseTaobaoRequest<WdtWmsStockinRefundQuerywithdetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.refund.querywithdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinRefundQuerywithdetailResponse> getResponseClass() {
		return WdtWmsStockinRefundQuerywithdetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 是否使用从库查询
		 */
		@ApiField("is_slave")
		private Boolean isSlave;
		/**
		 * 是否返回sn信息
		 */
		@ApiField("need_sn")
		private Boolean needSn;
		/**
		 * 退换单号
		 */
		@ApiField("refund_no")
		private String refundNo;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_nos")
		private String shopNos;
		/**
		 * 开始时间
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 入库单状态，英文逗号拼接的状态值:  10=已取消；20=编辑中；30=待审核；37=待质检；40=质检确认； 60=待结算；70=暂估结算；80=已完成
		 */
		@ApiField("status")
		private String status;
		/**
		 * 入库单号
		 */
		@ApiField("stockin_no")
		private String stockinNo;
		/**
		 * 时间条件类型（查询的时间条件类型, 0:修改时间; 1:入库时间 不传默认为0）
		 */
		@ApiField("time_type")
		private Long timeType;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public Boolean getIsSlave() {
			return this.isSlave;
		}
		public void setIsSlave(Boolean isSlave) {
			this.isSlave = isSlave;
		}
		public Boolean getNeedSn() {
			return this.needSn;
		}
		public void setNeedSn(Boolean needSn) {
			this.needSn = needSn;
		}
		public String getRefundNo() {
			return this.refundNo;
		}
		public void setRefundNo(String refundNo) {
			this.refundNo = refundNo;
		}
		public String getShopNos() {
			return this.shopNos;
		}
		public void setShopNos(String shopNos) {
			this.shopNos = shopNos;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStockinNo() {
			return this.stockinNo;
		}
		public void setStockinNo(String stockinNo) {
			this.stockinNo = stockinNo;
		}
		public Long getTimeType() {
			return this.timeType;
		}
		public void setTimeType(Long timeType) {
			this.timeType = timeType;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 分页
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}