package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinSmartrefundCreateextResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.smartrefund.createext request
 * 
 * @author top auto create
 * @since 1.0, 2020.08.28
 */
public class WdtWmsStockinSmartrefundCreateextRequest extends BaseTaobaoRequest<WdtWmsStockinSmartrefundCreateextResponse> {
     
     

	/** 
	* 是否允许退货货品数量大于购买数量
	 */
	private Boolean createPreStockin;

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 退货货品详细信息
	 */
	private String detailMapList;

	/** 
	* 退货信息
	 */
	private String refundInfo;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setCreatePreStockin(Boolean createPreStockin) {
		this.createPreStockin = createPreStockin;
	}

	public Boolean getCreatePreStockin() {
		return this.createPreStockin;
	}

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setDetailMapList(String detailMapList) {
		this.detailMapList = detailMapList;
	}

	public void setDetailMapList(List<DetailMapList> detailMapList) {
		this.detailMapList = new JSONWriter(false,false,true).write(detailMapList);
	}

	public String getDetailMapList() {
		return this.detailMapList;
	}

	public void setRefundInfo(String refundInfo) {
		this.refundInfo = refundInfo;
	}

	public void setRefundInfo(RefundInfo refundInfo) {
		this.refundInfo = new JSONWriter(false,false,true).write(refundInfo);
	}

	public String getRefundInfo() {
		return this.refundInfo;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.smartrefund.createext";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("createPreStockin", this.createPreStockin);
		txtParams.put("datetime", this.datetime);
		txtParams.put("detailMapList", this.detailMapList);
		txtParams.put("refundInfo", this.refundInfo);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinSmartrefundCreateextResponse> getResponseClass() {
		return WdtWmsStockinSmartrefundCreateextResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(detailMapList, 999999, "detailMapList");
     }
     
	/**
 * 退货信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class RefundInfo {

	/**
		 * 退货备注,无备注可以传空字符串
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 退货入库仓编号
		 */
		@ApiField("return_warehouse_no")
		private String returnWarehouseNo;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
	

	public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getReturnWarehouseNo() {
			return this.returnWarehouseNo;
		}
		public void setReturnWarehouseNo(String returnWarehouseNo) {
			this.returnWarehouseNo = returnWarehouseNo;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}

}

	/**
 * 退货货品详细信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("detailMapList")
public static class DetailMapList {

	/**
		 * 备注,无备注就传空字符串
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 规格码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 入库数量
		 */
		@ApiField("stockin_num")
		private String stockinNum;
	

	public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getStockinNum() {
			return this.stockinNum;
		}
		public void setStockinNum(String stockinNum) {
			this.stockinNum = stockinNum;
		}

}



}