package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockpdStocksyncbypdResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockpd.stocksyncbypd request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.16
 */
public class WdtWmsStockpdStocksyncbypdRequest extends BaseTaobaoRequest<WdtWmsStockpdStocksyncbypdResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 盘点单信息
	 */
	private String pdOrder;

	/** 
	* 盘点单明细，可以为空
	 */
	private String specList;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPdOrder(String pdOrder) {
		this.pdOrder = pdOrder;
	}

	public void setPdOrder(PdOrder pdOrder) {
		this.pdOrder = new JSONWriter(false,false,true).write(pdOrder);
	}

	public String getPdOrder() {
		return this.pdOrder;
	}

	public void setSpecList(String specList) {
		this.specList = specList;
	}

	public void setSpecList(List<SpecList> specList) {
		this.specList = new JSONWriter(false,false,true).write(specList);
	}

	public String getSpecList() {
		return this.specList;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockpd.stocksyncbypd";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pdOrder", this.pdOrder);
		txtParams.put("specList", this.specList);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockpdStocksyncbypdResponse> getResponseClass() {
		return WdtWmsStockpdStocksyncbypdResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(specList, 999999, "specList");
     }
     
	/**
 * 盘点单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class PdOrder {

	/**
		 * 正残次品处理方式:  0、全部 ; 1、只盘正品 ;  2、只盘残品
		 */
		@ApiField("defect_mode")
		private Long defectMode;
		/**
		 * 备注，若无可为””
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public Long getDefectMode() {
			return this.defectMode;
		}
		public void setDefectMode(Long defectMode) {
			this.defectMode = defectMode;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 盘点单明细，可以为空
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("specList")
public static class SpecList {

	/**
		 * 残次品备注(盘点录入的备注) 是否为残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 盘点数量
		 */
		@ApiField("new_num")
		private String newNum;
		/**
		 * 备注(盘点录入的备注)
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
	

	public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getNewNum() {
			return this.newNum;
		}
		public void setNewNum(String newNum) {
			this.newNum = newNum;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}

}



}