package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStocktransferEditCreateorderResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stocktransfer.edit.createorder request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.16
 */
public class WdtWmsStocktransferEditCreateorderRequest extends BaseTaobaoRequest<WdtWmsStocktransferEditCreateorderResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 调拨单明细信息
	 */
	private String detailList;

	/** 
	* 是否审核
	 */
	private Boolean isCheck;

	/** 
	* 调拨单单据信息
	 */
	private String orderInfo;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setDetailList(String detailList) {
		this.detailList = detailList;
	}

	public void setDetailList(List<DetailList> detailList) {
		this.detailList = new JSONWriter(false,false,true).write(detailList);
	}

	public String getDetailList() {
		return this.detailList;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public Boolean getIsCheck() {
		return this.isCheck;
	}

	public void setOrderInfo(String orderInfo) {
		this.orderInfo = orderInfo;
	}

	public void setOrderInfo(OrderInfo orderInfo) {
		this.orderInfo = new JSONWriter(false,false,true).write(orderInfo);
	}

	public String getOrderInfo() {
		return this.orderInfo;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stocktransfer.edit.createorder";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("detailList", this.detailList);
		txtParams.put("isCheck", this.isCheck);
		txtParams.put("orderInfo", this.orderInfo);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStocktransferEditCreateorderResponse> getResponseClass() {
		return WdtWmsStocktransferEditCreateorderResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(detailList, 999999, "detailList");
     }
     
	/**
 * 调拨单单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class OrderInfo {

	/**
		 * 地址
		 */
		@ApiField("address")
		private String address;
		/**
		 * 目标仓城市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 目标仓联系人
		 */
		@ApiField("contact")
		private String contact;
		/**
		 * 目标仓地区
		 */
		@ApiField("district")
		private String district;
		/**
		 * 调出仓库
		 */
		@ApiField("from_warehouse_no")
		private String fromWarehouseNo;
		/**
		 * 调拨类型 默认快速调拨。调拨类型：0单品调拨1,货位调拨2明细调拨3快递调拨
		 */
		@ApiField("mode")
		private Long mode;
		/**
		 * 外部单号
		 */
		@ApiField("outer_no")
		private String outerNo;
		/**
		 * 目标仓省份
		 */
		@ApiField("province")
		private String province;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 联系电话
		 */
		@ApiField("telno")
		private String telno;
		/**
		 * 调入仓库
		 */
		@ApiField("to_warehouse_no")
		private String toWarehouseNo;
	

	public String getAddress() {
			return this.address;
		}
		public void setAddress(String address) {
			this.address = address;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getContact() {
			return this.contact;
		}
		public void setContact(String contact) {
			this.contact = contact;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getFromWarehouseNo() {
			return this.fromWarehouseNo;
		}
		public void setFromWarehouseNo(String fromWarehouseNo) {
			this.fromWarehouseNo = fromWarehouseNo;
		}
		public Long getMode() {
			return this.mode;
		}
		public void setMode(Long mode) {
			this.mode = mode;
		}
		public String getOuterNo() {
			return this.outerNo;
		}
		public void setOuterNo(String outerNo) {
			this.outerNo = outerNo;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getTelno() {
			return this.telno;
		}
		public void setTelno(String telno) {
			this.telno = telno;
		}
		public String getToWarehouseNo() {
			return this.toWarehouseNo;
		}
		public void setToWarehouseNo(String toWarehouseNo) {
			this.toWarehouseNo = toWarehouseNo;
		}

}

	/**
 * 调拨单明细信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("detailList")
public static class DetailList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 调出货位
		 */
		@ApiField("from_position_no")
		private String fromPositionNo;
		/**
		 * 调拨数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 单品信息
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 调入货位
		 */
		@ApiField("to_position_no")
		private String toPositionNo;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getFromPositionNo() {
			return this.fromPositionNo;
		}
		public void setFromPositionNo(String fromPositionNo) {
			this.fromPositionNo = fromPositionNo;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getToPositionNo() {
			return this.toPositionNo;
		}
		public void setToPositionNo(String toPositionNo) {
			this.toPositionNo = toPositionNo;
		}

}



}