package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.refund.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockinRefundQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5457267545589154474L;

	/** 
	 * 退货入库单信息
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码，返回0为正常
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 退换单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class RefundOrderDetailList {

	/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 价格
		 */
		@ApiField("price")
		private String price;
		/**
		 * 退换单明细id
		 */
		@ApiField("refund_order_id")
		private Long refundOrderId;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 入库单明细id
		 */
		@ApiField("stockin_order_detail_id")
		private Long stockinOrderDetailId;
	

	public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public Long getRefundOrderId() {
			return this.refundOrderId;
		}
		public void setRefundOrderId(Long refundOrderId) {
			this.refundOrderId = refundOrderId;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getStockinOrderDetailId() {
			return this.stockinOrderDetailId;
		}
		public void setStockinOrderDetailId(Long stockinOrderDetailId) {
			this.stockinOrderDetailId = stockinOrderDetailId;
		}

}

	/**
 * 入库单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailsList {

	/**
		 * 调整数量
		 */
		@ApiField("adjust_num")
		private String adjustNum;
		/**
		 * 基本单位id
		 */
		@ApiField("base_unit_id")
		private Long baseUnitId;
		/**
		 * 基本单位名称
		 */
		@ApiField("base_unit_name")
		private String baseUnitName;
		/**
		 * 批次id
		 */
		@ApiField("batch_id")
		private Long batchId;
		/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 品牌编号
		 */
		@ApiField("brand_no")
		private String brandNo;
		/**
		 * 入库单审核时的成本价
		 */
		@ApiField("checked_cost_price")
		private String checkedCostPrice;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 预期数量
		 */
		@ApiField("expect_num")
		private String expectNum;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 货品id
		 */
		@ApiField("goods_id")
		private Long goodsId;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 入库单位名称
		 */
		@ApiField("goods_unit")
		private String goodsUnit;
		/**
		 * 物流公司id
		 */
		@ApiField("logistics_id")
		private Long logisticsId;
		/**
		 * 物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 辅助数量
		 */
		@ApiField("num2")
		private String num2;
		/**
		 * 库存明细id
		 */
		@ApiField("org_stockin_detail_id")
		private Long orgStockinDetailId;
		/**
		 * 货位id
		 */
		@ApiField("position_id")
		private Long positionId;
		/**
		 * 货位
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 生产日期
		 */
		@ApiField("production_date")
		private String productionDate;
		/**
		 * 自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 明细id(主键)
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 退款金额
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 退换单明细id
		 */
		@ApiField("refund_detail_id")
		private String refundDetailId;
		/**
		 * 退换单明细
		 */
		@ApiListField("refund_order_detail_list")
		@ApiField("refundOrderDetailList")
		private List<RefundOrderDetailList> refundOrderDetailList;
		/**
		 * 明细备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 调整后数量
		 */
		@ApiField("right_num")
		private String rightNum;
		/**
		 * 英文逗号拼接的sn
		 */
		@ApiField("sn_list")
		private String snList;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 单品id
		 */
		@ApiField("spec_id")
		private Long specId;
		/**
		 * 规格名
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 退换单id
		 */
		@ApiField("src_order_id")
		private Long srcOrderId;
		/**
		 * 业务单类型
		 */
		@ApiField("src_order_type")
		private Long srcOrderType;
		/**
		 * 入库单id
		 */
		@ApiField("stockin_id")
		private Long stockinId;
		/**
		 * 入库数量
		 */
		@ApiField("stockin_num")
		private String stockinNum;
		/**
		 * 总成本
		 */
		@ApiField("total_cost")
		private String totalCost;
		/**
		 * 入库单位id
		 */
		@ApiField("unit_id")
		private Long unitId;
		/**
		 * 单位换算关系
		 */
		@ApiField("unit_ratio")
		private String unitRatio;
		/**
		 * 有效期天数
		 */
		@ApiField("validity_days")
		private Long validityDays;
		/**
		 * 仓库id
		 */
		@ApiField("warehouse_id")
		private Long warehouseId;
	

	public String getAdjustNum() {
			return this.adjustNum;
		}
		public void setAdjustNum(String adjustNum) {
			this.adjustNum = adjustNum;
		}
		public Long getBaseUnitId() {
			return this.baseUnitId;
		}
		public void setBaseUnitId(Long baseUnitId) {
			this.baseUnitId = baseUnitId;
		}
		public String getBaseUnitName() {
			return this.baseUnitName;
		}
		public void setBaseUnitName(String baseUnitName) {
			this.baseUnitName = baseUnitName;
		}
		public Long getBatchId() {
			return this.batchId;
		}
		public void setBatchId(Long batchId) {
			this.batchId = batchId;
		}
		public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getBrandNo() {
			return this.brandNo;
		}
		public void setBrandNo(String brandNo) {
			this.brandNo = brandNo;
		}
		public String getCheckedCostPrice() {
			return this.checkedCostPrice;
		}
		public void setCheckedCostPrice(String checkedCostPrice) {
			this.checkedCostPrice = checkedCostPrice;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpectNum() {
			return this.expectNum;
		}
		public void setExpectNum(String expectNum) {
			this.expectNum = expectNum;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public Long getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(Long goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getGoodsUnit() {
			return this.goodsUnit;
		}
		public void setGoodsUnit(String goodsUnit) {
			this.goodsUnit = goodsUnit;
		}
		public Long getLogisticsId() {
			return this.logisticsId;
		}
		public void setLogisticsId(Long logisticsId) {
			this.logisticsId = logisticsId;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getNum2() {
			return this.num2;
		}
		public void setNum2(String num2) {
			this.num2 = num2;
		}
		public Long getOrgStockinDetailId() {
			return this.orgStockinDetailId;
		}
		public void setOrgStockinDetailId(Long orgStockinDetailId) {
			this.orgStockinDetailId = orgStockinDetailId;
		}
		public Long getPositionId() {
			return this.positionId;
		}
		public void setPositionId(Long positionId) {
			this.positionId = positionId;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getProductionDate() {
			return this.productionDate;
		}
		public void setProductionDate(String productionDate) {
			this.productionDate = productionDate;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public String getRefundDetailId() {
			return this.refundDetailId;
		}
		public void setRefundDetailId(String refundDetailId) {
			this.refundDetailId = refundDetailId;
		}
		public List<RefundOrderDetailList> getRefundOrderDetailList() {
			return this.refundOrderDetailList;
		}
		public void setRefundOrderDetailList(List<RefundOrderDetailList> refundOrderDetailList) {
			this.refundOrderDetailList = refundOrderDetailList;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getRightNum() {
			return this.rightNum;
		}
		public void setRightNum(String rightNum) {
			this.rightNum = rightNum;
		}
		public String getSnList() {
			return this.snList;
		}
		public void setSnList(String snList) {
			this.snList = snList;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public Long getSpecId() {
			return this.specId;
		}
		public void setSpecId(Long specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getSrcOrderId() {
			return this.srcOrderId;
		}
		public void setSrcOrderId(Long srcOrderId) {
			this.srcOrderId = srcOrderId;
		}
		public Long getSrcOrderType() {
			return this.srcOrderType;
		}
		public void setSrcOrderType(Long srcOrderType) {
			this.srcOrderType = srcOrderType;
		}
		public Long getStockinId() {
			return this.stockinId;
		}
		public void setStockinId(Long stockinId) {
			this.stockinId = stockinId;
		}
		public String getStockinNum() {
			return this.stockinNum;
		}
		public void setStockinNum(String stockinNum) {
			this.stockinNum = stockinNum;
		}
		public String getTotalCost() {
			return this.totalCost;
		}
		public void setTotalCost(String totalCost) {
			this.totalCost = totalCost;
		}
		public Long getUnitId() {
			return this.unitId;
		}
		public void setUnitId(Long unitId) {
			this.unitId = unitId;
		}
		public String getUnitRatio() {
			return this.unitRatio;
		}
		public void setUnitRatio(String unitRatio) {
			this.unitRatio = unitRatio;
		}
		public Long getValidityDays() {
			return this.validityDays;
		}
		public void setValidityDays(Long validityDays) {
			this.validityDays = validityDays;
		}
		public Long getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(Long warehouseId) {
			this.warehouseId = warehouseId;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 退换单实际退款金额
		 */
		@ApiField("actual_refund_amount")
		private String actualRefundAmount;
		/**
		 * 调整数量
		 */
		@ApiField("adjust_num")
		private String adjustNum;
		/**
		 * 关联类型
		 */
		@ApiField("attach_type")
		private Long attachType;
		/**
		 * 审核人id	
		 */
		@ApiField("check_operator_id")
		private Long checkOperatorId;
		/**
		 * 审核人	
		 */
		@ApiField("check_operator_name")
		private String checkOperatorName;
		/**
		 * 审核时间
		 */
		@ApiField("check_time")
		private String checkTime;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 入库单创建时间
		 */
		@ApiField("created_time")
		private String createdTime;
		/**
		 * 客户名称
		 */
		@ApiField("customer_name")
		private String customerName;
		/**
		 * 客户编码
		 */
		@ApiField("customer_no")
		private String customerNo;
		/**
		 * 入库单明细
		 */
		@ApiListField("details_list")
		@ApiField("detailsList")
		private List<DetailsList> detailsList;
		/**
		 * 分销商
		 */
		@ApiField("fenxiao_nick")
		private String fenxiaoNick;
		/**
		 * 标记id
		 */
		@ApiField("flag_id")
		private Long flagId;
		/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 货品总数
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 货品类型数量
		 */
		@ApiField("goods_type_count")
		private Long goodsTypeCount;
		/**
		 * 物流公司主键
		 */
		@ApiField("logistics_id")
		private Long logisticsId;
		/**
		 * 物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流单号字段
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 物流方式
		 */
		@ApiField("logistics_type")
		private Long logisticsType;
		/**
		 * 退货入库单最后修改时间, 样例: 2020-04-23 14:55:08
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 客户网名
		 */
		@ApiField("nick_name")
		private String nickName;
		/**
		 * 便签条数
		 */
		@ApiField("note_count")
		private Long noteCount;
		/**
		 * 入库人id	
		 */
		@ApiField("operator_id")
		private Long operatorId;
		/**
		 * 入库人
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 入库单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 退换单状态
		 */
		@ApiField("process_status")
		private Long processStatus;
		/**
		 * 退换说明	
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 退换说明id	
		 */
		@ApiField("reason_id")
		private Long reasonId;
		/**
		 * 入库单明细退款金额之和
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 退换单号
		 */
		@ApiField("refund_no")
		private String refundNo;
		/**
		 * 入库单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 序号
		 */
		@ApiField("seq_no")
		private String seqNo;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 店铺平台id
		 */
		@ApiField("shop_platform_id")
		private Long shopPlatformId;
		/**
		 * 店铺备注
		 */
		@ApiField("shop_remark")
		private String shopRemark;
		/**
		 * 退换单id
		 */
		@ApiField("src_order_id")
		private Long srcOrderId;
		/**
		 * 退换单编号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 业务单类型
		 */
		@ApiField("src_order_type")
		private Long srcOrderType;
		/**
		 * 入库单状态，参考传入参数描述
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 入库单id
		 */
		@ApiField("stockin_id")
		private Long stockinId;
		/**
		 * 入库时间（实际为最后一次修改时间）
		 */
		@ApiField("stockin_time")
		private String stockinTime;
		/**
		 * 子平台id
		 */
		@ApiField("sub_platform_id")
		private Long subPlatformId;
		/**
		 * 原始单号
		 */
		@ApiField("tid_list")
		private String tidList;
		/**
		 * 货品入库总数量
		 */
		@ApiField("total_goods_stockin_num")
		private String totalGoodsStockinNum;
		/**
		 * 总金额
		 */
		@ApiField("total_price")
		private String totalPrice;
		/**
		 * 订单编号，若为多个则以“,”分割
		 */
		@ApiField("trade_no_list")
		private String tradeNoList;
		/**
		 * 仓库id
		 */
		@ApiField("warehouse_id")
		private Long warehouseId;
		/**
		 * 仓库名称
		 */
		@ApiField("warehouse_name")
		private String warehouseName;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getActualRefundAmount() {
			return this.actualRefundAmount;
		}
		public void setActualRefundAmount(String actualRefundAmount) {
			this.actualRefundAmount = actualRefundAmount;
		}
		public String getAdjustNum() {
			return this.adjustNum;
		}
		public void setAdjustNum(String adjustNum) {
			this.adjustNum = adjustNum;
		}
		public Long getAttachType() {
			return this.attachType;
		}
		public void setAttachType(Long attachType) {
			this.attachType = attachType;
		}
		public Long getCheckOperatorId() {
			return this.checkOperatorId;
		}
		public void setCheckOperatorId(Long checkOperatorId) {
			this.checkOperatorId = checkOperatorId;
		}
		public String getCheckOperatorName() {
			return this.checkOperatorName;
		}
		public void setCheckOperatorName(String checkOperatorName) {
			this.checkOperatorName = checkOperatorName;
		}
		public String getCheckTime() {
			return this.checkTime;
		}
		public void setCheckTime(String checkTime) {
			this.checkTime = checkTime;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getCreatedTime() {
			return this.createdTime;
		}
		public void setCreatedTime(String createdTime) {
			this.createdTime = createdTime;
		}
		public String getCustomerName() {
			return this.customerName;
		}
		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}
		public String getCustomerNo() {
			return this.customerNo;
		}
		public void setCustomerNo(String customerNo) {
			this.customerNo = customerNo;
		}
		public List<DetailsList> getDetailsList() {
			return this.detailsList;
		}
		public void setDetailsList(List<DetailsList> detailsList) {
			this.detailsList = detailsList;
		}
		public String getFenxiaoNick() {
			return this.fenxiaoNick;
		}
		public void setFenxiaoNick(String fenxiaoNick) {
			this.fenxiaoNick = fenxiaoNick;
		}
		public Long getFlagId() {
			return this.flagId;
		}
		public void setFlagId(Long flagId) {
			this.flagId = flagId;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public Long getGoodsTypeCount() {
			return this.goodsTypeCount;
		}
		public void setGoodsTypeCount(Long goodsTypeCount) {
			this.goodsTypeCount = goodsTypeCount;
		}
		public Long getLogisticsId() {
			return this.logisticsId;
		}
		public void setLogisticsId(Long logisticsId) {
			this.logisticsId = logisticsId;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public Long getLogisticsType() {
			return this.logisticsType;
		}
		public void setLogisticsType(Long logisticsType) {
			this.logisticsType = logisticsType;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getNickName() {
			return this.nickName;
		}
		public void setNickName(String nickName) {
			this.nickName = nickName;
		}
		public Long getNoteCount() {
			return this.noteCount;
		}
		public void setNoteCount(Long noteCount) {
			this.noteCount = noteCount;
		}
		public Long getOperatorId() {
			return this.operatorId;
		}
		public void setOperatorId(Long operatorId) {
			this.operatorId = operatorId;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public Long getProcessStatus() {
			return this.processStatus;
		}
		public void setProcessStatus(Long processStatus) {
			this.processStatus = processStatus;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public Long getReasonId() {
			return this.reasonId;
		}
		public void setReasonId(Long reasonId) {
			this.reasonId = reasonId;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public String getRefundNo() {
			return this.refundNo;
		}
		public void setRefundNo(String refundNo) {
			this.refundNo = refundNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSeqNo() {
			return this.seqNo;
		}
		public void setSeqNo(String seqNo) {
			this.seqNo = seqNo;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public Long getShopPlatformId() {
			return this.shopPlatformId;
		}
		public void setShopPlatformId(Long shopPlatformId) {
			this.shopPlatformId = shopPlatformId;
		}
		public String getShopRemark() {
			return this.shopRemark;
		}
		public void setShopRemark(String shopRemark) {
			this.shopRemark = shopRemark;
		}
		public Long getSrcOrderId() {
			return this.srcOrderId;
		}
		public void setSrcOrderId(Long srcOrderId) {
			this.srcOrderId = srcOrderId;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public Long getSrcOrderType() {
			return this.srcOrderType;
		}
		public void setSrcOrderType(Long srcOrderType) {
			this.srcOrderType = srcOrderType;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStockinId() {
			return this.stockinId;
		}
		public void setStockinId(Long stockinId) {
			this.stockinId = stockinId;
		}
		public String getStockinTime() {
			return this.stockinTime;
		}
		public void setStockinTime(String stockinTime) {
			this.stockinTime = stockinTime;
		}
		public Long getSubPlatformId() {
			return this.subPlatformId;
		}
		public void setSubPlatformId(Long subPlatformId) {
			this.subPlatformId = subPlatformId;
		}
		public String getTidList() {
			return this.tidList;
		}
		public void setTidList(String tidList) {
			this.tidList = tidList;
		}
		public String getTotalGoodsStockinNum() {
			return this.totalGoodsStockinNum;
		}
		public void setTotalGoodsStockinNum(String totalGoodsStockinNum) {
			this.totalGoodsStockinNum = totalGoodsStockinNum;
		}
		public String getTotalPrice() {
			return this.totalPrice;
		}
		public void setTotalPrice(String totalPrice) {
			this.totalPrice = totalPrice;
		}
		public String getTradeNoList() {
			return this.tradeNoList;
		}
		public void setTradeNoList(String tradeNoList) {
			this.tradeNoList = tradeNoList;
		}
		public Long getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(Long warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseName() {
			return this.warehouseName;
		}
		public void setWarehouseName(String warehouseName) {
			this.warehouseName = warehouseName;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 退货入库单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
