package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockspec.querychangehistory response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockspecQuerychangehistoryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5858422592132363948L;

	/** 
	 * 单据数据
	 */
	@ApiField("data")
	private DataInfo data;

	/** 
	 * 错误信息 无错误信息不返回
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码返回0为正常
	 */
	@ApiField("status")
	private Long status;


	public void setData(DataInfo data) {
		this.data = data;
	}
	public DataInfo getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 单据数据 库存信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 本次出入库存
		 */
		@ApiField("num")
		private String num;
		/**
		 * 操作人
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 出入库单据对应的原单据号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 操作 2 调拨入库 4 盘点入库 5 生产原料入库 6 生产成品入库 7 保修入库 8 纠错入库 10 采购入库 13 JIT退货入库 20 其它入库 22 退货预入库 23 调整入库 33 初始化入库  1 销售出库 2 调拨出库 4 盘亏出库 5 生产出库 14 采购退货出库 21 其它出库 24 调整出库 34 初始化出库
		 */
		@ApiField("src_order_type")
		private Long srcOrderType;
		/**
		 * 后库存
		 */
		@ApiField("stock_num_new")
		private String stockNumNew;
		/**
		 * 前库存
		 */
		@ApiField("stock_num_old")
		private String stockNumOld;
		/**
		 * 出入库单号
		 */
		@ApiField("stockio_no")
		private String stockioNo;
		/**
		 * 类型
		 */
		@ApiField("type")
		private Long type;
		/**
		 * 仓库名称
		 */
		@ApiField("warehouse_name")
		private String warehouseName;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public Long getSrcOrderType() {
			return this.srcOrderType;
		}
		public void setSrcOrderType(Long srcOrderType) {
			this.srcOrderType = srcOrderType;
		}
		public String getStockNumNew() {
			return this.stockNumNew;
		}
		public void setStockNumNew(String stockNumNew) {
			this.stockNumNew = stockNumNew;
		}
		public String getStockNumOld() {
			return this.stockNumOld;
		}
		public void setStockNumOld(String stockNumOld) {
			this.stockNumOld = stockNumOld;
		}
		public String getStockioNo() {
			return this.stockioNo;
		}
		public void setStockioNo(String stockioNo) {
			this.stockioNo = stockioNo;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}
		public String getWarehouseName() {
			return this.warehouseName;
		}
		public void setWarehouseName(String warehouseName) {
			this.warehouseName = warehouseName;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DataInfo {

	/**
		 * 单据数据 库存信息列表
		 */
		@ApiListField("data")
		@ApiField("data")
		private List<Data> data;
		/**
		 * 总数 查询条件总单据数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Data> getData() {
			return this.data;
		}
		public void setData(List<Data> data) {
			this.data = data;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
