package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * o2o订单买家实际支付时，使用的支付渠道信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class AcquireOrderPayChannel extends TaobaoObject {

	private static final long serialVersionUID = 3883117772178376895L;

	/**
	 * 支付渠道名
	 */
	@ApiField("pay_channel")
	private String payChannel;

	/**
	 * 支付渠道名字
	 */
	@ApiField("pay_channel_name")
	private String payChannelName;

	/**
	 * 买家使用该支付渠道，支付的金额，单位为分
	 */
	@ApiField("pay_fee")
	private Long payFee;

	/**
	 * 渠道优惠金额
	 */
	@ApiField("promotion_fee")
	private Long promotionFee;


	public String getPayChannel() {
		return this.payChannel;
	}
	public void setPayChannel(String payChannel) {
		this.payChannel = payChannel;
	}

	public String getPayChannelName() {
		return this.payChannelName;
	}
	public void setPayChannelName(String payChannelName) {
		this.payChannelName = payChannelName;
	}

	public Long getPayFee() {
		return this.payFee;
	}
	public void setPayFee(Long payFee) {
		this.payFee = payFee;
	}

	public Long getPromotionFee() {
		return this.promotionFee;
	}
	public void setPromotionFee(Long promotionFee) {
		this.promotionFee = promotionFee;
	}

}
