package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 淘宝内部优惠券信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class OtoTaobaoCoupon extends TaobaoObject {

	private static final long serialVersionUID = 7344536225186818746L;

	/**
	 * 是否可用 1 表示可用，0表示不可用
	 */
	@ApiField("active")
	private Long active;

	/**
	 * 买家领取的优惠券ID
	 */
	@ApiField("coupon_id")
	private String couponId;

	/**
	 * 优惠券名称
	 */
	@ApiField("coupon_name")
	private String couponName;

	/**
	 * 优惠券类型 目前只有ump线下优惠券
	 */
	@ApiField("coupon_type")
	private String couponType;

	/**
	 * 券抵扣金额
	 */
	@ApiField("discount_fee")
	private Long discountFee;

	/**
	 * 结束日期
	 */
	@ApiField("end_date")
	private String endDate;

	/**
	 * 券的优惠金额,目前喵街储值卡有这个功能
	 */
	@ApiField("promotion_fee")
	private Long promotionFee;

	/**
	 * 是否选中券 1 表示选中 0为选中
	 */
	@ApiField("selected")
	private Long selected;

	/**
	 * 核销流水号
	 */
	@ApiField("serial_number")
	private String serialNumber;

	/**
	 * 专柜编码
	 */
	@ApiField("shop_code")
	private String shopCode;

	/**
	 * 开始日期
	 */
	@ApiField("start_date")
	private String startDate;

	/**
	 * 优惠券的起始金额
	 */
	@ApiField("start_fee")
	private Long startFee;


	public Long getActive() {
		return this.active;
	}
	public void setActive(Long active) {
		this.active = active;
	}

	public String getCouponId() {
		return this.couponId;
	}
	public void setCouponId(String couponId) {
		this.couponId = couponId;
	}

	public String getCouponName() {
		return this.couponName;
	}
	public void setCouponName(String couponName) {
		this.couponName = couponName;
	}

	public String getCouponType() {
		return this.couponType;
	}
	public void setCouponType(String couponType) {
		this.couponType = couponType;
	}

	public Long getDiscountFee() {
		return this.discountFee;
	}
	public void setDiscountFee(Long discountFee) {
		this.discountFee = discountFee;
	}

	public String getEndDate() {
		return this.endDate;
	}
	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public Long getPromotionFee() {
		return this.promotionFee;
	}
	public void setPromotionFee(Long promotionFee) {
		this.promotionFee = promotionFee;
	}

	public Long getSelected() {
		return this.selected;
	}
	public void setSelected(Long selected) {
		this.selected = selected;
	}

	public String getSerialNumber() {
		return this.serialNumber;
	}
	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}

	public String getShopCode() {
		return this.shopCode;
	}
	public void setShopCode(String shopCode) {
		this.shopCode = shopCode;
	}

	public String getStartDate() {
		return this.startDate;
	}
	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public Long getStartFee() {
		return this.startFee;
	}
	public void setStartFee(Long startFee) {
		this.startFee = startFee;
	}

}
