package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsConsignModifyResponse;

/**
 * TOP API: alibaba.ascp.logistics.consign.modify request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.20
 */
public class AlibabaAscpLogisticsConsignModifyRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsConsignModifyResponse> {
	
	

	/** 
	* feature参数格式，KV之间用“=”分隔，多个key之间用”;”分隔 ，范例: instantMobilePhoneNumber=12345678910表示同城配送物流公司的物流订单收货人手机号，支持11位真实号和15位隐私号"12345678910-1234"。
	 */
	private String feature;

	/** 
	* 原包裹中的商品信息
	 */
	private String goods;

	/** 
	* 新物流公司代码.如"POST"代表中国邮政,"ZJS"代表宅急送。调用 taobao.logistics.companies.get 获取
	 */
	private String newCompanyCode;

	/** 
	* 新运单号.具体一个物流公司的真实运单号码。淘宝官方物流会校验，请谨慎传入
	 */
	private String newOutSid;

	/** 
	* 原物流公司代码.如"POST"代表中国邮政,"ZJS"代表宅急送。调用 taobao.logistics.companies.get 获取
	 */
	private String oldCompanyCode;

	/** 
	* 原运单号.具体一个物流公司的真实运单号码。淘宝官方物流会校验，请谨慎传入
	 */
	private String oldOutSid;

	/** 
	* 订单id
	 */
	private String tid;

	public void setFeature(String feature) {
		this.feature = feature;
	}

	public String getFeature() {
		return this.feature;
	}

	public void setGoods(String goods) {
		this.goods = goods;
	}

	public void setGoods(List<TopConsignGoodsRequest> goods) {
		this.goods = new JSONWriter(false,true).write(goods);
	}

	public String getGoods() {
		return this.goods;
	}

	public void setNewCompanyCode(String newCompanyCode) {
		this.newCompanyCode = newCompanyCode;
	}

	public String getNewCompanyCode() {
		return this.newCompanyCode;
	}

	public void setNewOutSid(String newOutSid) {
		this.newOutSid = newOutSid;
	}

	public String getNewOutSid() {
		return this.newOutSid;
	}

	public void setOldCompanyCode(String oldCompanyCode) {
		this.oldCompanyCode = oldCompanyCode;
	}

	public String getOldCompanyCode() {
		return this.oldCompanyCode;
	}

	public void setOldOutSid(String oldOutSid) {
		this.oldOutSid = oldOutSid;
	}

	public String getOldOutSid() {
		return this.oldOutSid;
	}

	public void setTid(String tid) {
		this.tid = tid;
	}

	public String getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.consign.modify";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("feature", this.feature);
		txtParams.put("goods", this.goods);
		txtParams.put("new_company_code", this.newCompanyCode);
		txtParams.put("new_out_sid", this.newOutSid);
		txtParams.put("old_company_code", this.oldCompanyCode);
		txtParams.put("old_out_sid", this.oldOutSid);
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsConsignModifyResponse> getResponseClass() {
		return AlibabaAscpLogisticsConsignModifyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(newOutSid, "newOutSid");
		RequestCheckUtils.checkNotEmpty(oldOutSid, "oldOutSid");
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	
	/**
 * 原包裹中的商品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopConsignGoodsRequest extends TaobaoObject {

	private static final long serialVersionUID = 1137955229315938475L;

	/**
		 * 成分品itemId
		 */
		@ApiField("comp_item_id")
		private String compItemId;
		/**
		 * 成分品skuId
		 */
		@ApiField("comp_sku_id")
		private String compSkuId;
		/**
		 * 商品类型 0：普通品 1:赠品 2:成分品，默认0
		 */
		@ApiField("item_type")
		private Long itemType;
		/**
		 * 子订单id
		 */
		@ApiField("sub_tid")
		private String subTid;
	

	public String getCompItemId() {
			return this.compItemId;
		}
		public void setCompItemId(String compItemId) {
			this.compItemId = compItemId;
		}
		public String getCompSkuId() {
			return this.compSkuId;
		}
		public void setCompSkuId(String compSkuId) {
			this.compSkuId = compSkuId;
		}
		public Long getItemType() {
			return this.itemType;
		}
		public void setItemType(Long itemType) {
			this.itemType = itemType;
		}
		public String getSubTid() {
			return this.subTid;
		}
		public void setSubTid(String subTid) {
			this.subTid = subTid;
		}

}


}