package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsConsignResendResponse;

/**
 * TOP API: alibaba.ascp.logistics.consign.resend request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.01
 */
public class AlibabaAscpLogisticsConsignResendRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsConsignResendResponse> {
	
	

	/** 
	* 包裹包含的运单号及快递公司编号,多包裹时，需要包含所有包裹的运单号等信息
	 */
	private String consignPkgs;

	/** 
	* feature参数格式，KV之间用“=”分隔，多个key之间用”;”分隔 ，范例: instantMobilePhoneNumber=12345678910表示同城配送物流公司的物流订单收货人手机号，支持11位真实号和15位隐私号"12345678910-1234"
	 */
	private String feature;

	/** 
	* 拆单子订单列表，对应的数据是：子订单号列表。可以不传，但是如果传了则必须符合传递的规则。子订单必须是操作的物流订单的子订单的真子集
	 */
	private String subTids;

	/** 
	* 订单id
	 */
	private String tid;

	public void setConsignPkgs(String consignPkgs) {
		this.consignPkgs = consignPkgs;
	}

	public void setConsignPkgs(List<TopConsignPkgRequest> consignPkgs) {
		this.consignPkgs = new JSONWriter(false,true).write(consignPkgs);
	}

	public String getConsignPkgs() {
		return this.consignPkgs;
	}

	public void setFeature(String feature) {
		this.feature = feature;
	}

	public String getFeature() {
		return this.feature;
	}

	public void setSubTids(String subTids) {
		this.subTids = subTids;
	}

	public String getSubTids() {
		return this.subTids;
	}

	public void setTid(String tid) {
		this.tid = tid;
	}

	public String getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.consign.resend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("consign_pkgs", this.consignPkgs);
		txtParams.put("feature", this.feature);
		txtParams.put("sub_tids", this.subTids);
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsConsignResendResponse> getResponseClass() {
		return AlibabaAscpLogisticsConsignResendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(consignPkgs, 999, "consignPkgs");
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	
	/**
 * 包裹包含的运单号及快递公司编号,多包裹时，需要包含所有包裹的运单号等信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopConsignPkgRequest extends TaobaoObject {

	private static final long serialVersionUID = 7683175945698526476L;

	/**
		 * 物流公司代码.如"POST"代表中国邮政,"ZJS"代表宅急送。调用 taobao.logistics.companies.get 获取
		 */
		@ApiField("company_code")
		private String companyCode;
		/**
		 * 运单号.具体一个物流公司的真实运单号码。淘宝官方物流会校验，请谨慎传入
		 */
		@ApiField("out_sid")
		private String outSid;
	

	public String getCompanyCode() {
			return this.companyCode;
		}
		public void setCompanyCode(String companyCode) {
			this.companyCode = companyCode;
		}
		public String getOutSid() {
			return this.outSid;
		}
		public void setOutSid(String outSid) {
			this.outSid = outSid;
		}

}


}