package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaEinvoiceItemUpdateResponse;

/**
 * TOP API: alibaba.einvoice.item.update request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.01
 */
public class AlibabaEinvoiceItemUpdateRequest extends BaseTaobaoRequest<AlibabaEinvoiceItemUpdateResponse> {
	
	

	/** 
	* 商品的开票名称，对应发票的货物劳务名称，值DELETE时表示删除
	 */
	private String invoiceName;

	/** 
	* 商品id，优先级高于outerId，商品必须归属于店铺，itemId和outerId不能同时为空
	 */
	private Long itemId;

	/** 
	* 税收分类编码，需要精确到叶子节点，必须和taxRate同时修改或删除，值DELETE时表示删除
	 */
	private String itemNo;

	/** 
	* 商家外部商品id，如果outerId对应了多个天猫sku，则会更新所有的sku开票信息。itemId和outerId不能同时为空
	 */
	private String outerId;

	/** 
	* skuId，必须是itemId下的sku，填写skuId后，修改和删除sku的开票信息
	 */
	private Long skuId;

	/** 
	* 规格型号，值DELETE时表示删除
	 */
	private String specification;

	/** 
	* 税率，可选值0，3，4，5，6，10，11，13， 16，17，必须和itemNo同时修改或删除,值为DELETE时表示删除
	 */
	private String taxRate;

	/** 
	* 单位，值DELETE时表示删除
	 */
	private String unit;

	/** 
	* 是否根据outerId更新所有对应sku的开票信息，true=更新，false=开票信息维护在发票平台；自动开票时，根据skuId获取outerId，再根据outerId查询开票信息。outerId不为空时必填
	 */
	private Boolean updateSku;

	/** 
	* 0税率标识，只有税率为0的情况才有值，0=出口零税率，1=免税，2=不征收，3=普通零税率，值为DELETE时表示删除
	 */
	private String zeroRateFlag;

	public void setInvoiceName(String invoiceName) {
		this.invoiceName = invoiceName;
	}

	public String getInvoiceName() {
		return this.invoiceName;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public void setItemNo(String itemNo) {
		this.itemNo = itemNo;
	}

	public String getItemNo() {
		return this.itemNo;
	}

	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getOuterId() {
		return this.outerId;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public Long getSkuId() {
		return this.skuId;
	}

	public void setSpecification(String specification) {
		this.specification = specification;
	}

	public String getSpecification() {
		return this.specification;
	}

	public void setTaxRate(String taxRate) {
		this.taxRate = taxRate;
	}

	public String getTaxRate() {
		return this.taxRate;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getUnit() {
		return this.unit;
	}

	public void setUpdateSku(Boolean updateSku) {
		this.updateSku = updateSku;
	}

	public Boolean getUpdateSku() {
		return this.updateSku;
	}

	public void setZeroRateFlag(String zeroRateFlag) {
		this.zeroRateFlag = zeroRateFlag;
	}

	public String getZeroRateFlag() {
		return this.zeroRateFlag;
	}

	public String getApiMethodName() {
		return "alibaba.einvoice.item.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("invoice_name", this.invoiceName);
		txtParams.put("item_id", this.itemId);
		txtParams.put("item_no", this.itemNo);
		txtParams.put("outer_id", this.outerId);
		txtParams.put("sku_id", this.skuId);
		txtParams.put("specification", this.specification);
		txtParams.put("tax_rate", this.taxRate);
		txtParams.put("unit", this.unit);
		txtParams.put("update_sku", this.updateSku);
		txtParams.put("zero_rate_flag", this.zeroRateFlag);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaEinvoiceItemUpdateResponse> getResponseClass() {
		return AlibabaEinvoiceItemUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(invoiceName, 65, "invoiceName");
		RequestCheckUtils.checkMaxLength(itemNo, 19, "itemNo");
		RequestCheckUtils.checkMaxLength(specification, 20, "specification");
		RequestCheckUtils.checkMaxLength(taxRate, 6, "taxRate");
		RequestCheckUtils.checkMaxLength(unit, 10, "unit");
		RequestCheckUtils.checkMaxLength(zeroRateFlag, 6, "zeroRateFlag");
	}
	

}