package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FenxiaoProductImportFromAuctionResponse;

/**
 * TOP API: taobao.fenxiao.product.import.from.auction request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.01
 */
public class FenxiaoProductImportFromAuctionRequest extends BaseTaobaoRequest<FenxiaoProductImportFromAuctionResponse> {
	
	

	/** 
	* 店铺宝贝id
	 */
	private Long auctionId;

	/** 
	* 产品线id
	 */
	private Long productLineId;

	/** 
	* 导入产品需要支持的交易类型：[1 代销][ 2 经销 ][3 代销和经销]
	 */
	private Long tradeType;

	public void setAuctionId(Long auctionId) {
		this.auctionId = auctionId;
	}

	public Long getAuctionId() {
		return this.auctionId;
	}

	public void setProductLineId(Long productLineId) {
		this.productLineId = productLineId;
	}

	public Long getProductLineId() {
		return this.productLineId;
	}

	public void setTradeType(Long tradeType) {
		this.tradeType = tradeType;
	}

	public Long getTradeType() {
		return this.tradeType;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.product.import.from.auction";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("auction_id", this.auctionId);
		txtParams.put("product_line_id", this.productLineId);
		txtParams.put("trade_type", this.tradeType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoProductImportFromAuctionResponse> getResponseClass() {
		return FenxiaoProductImportFromAuctionResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(auctionId, "auctionId");
		RequestCheckUtils.checkNotEmpty(productLineId, "productLineId");
		RequestCheckUtils.checkNotEmpty(tradeType, "tradeType");
	}
	

}