package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FulfillmentOrderAssembleResponse;

/**
 * TOP API: taobao.fulfillment.order.assemble request
 * 
 * @author top auto create
 * @since 1.0, 2022.06.15
 */
public class FulfillmentOrderAssembleRequest extends BaseTaobaoRequest<FulfillmentOrderAssembleResponse> {
	
	

	/** 
	* 批量回传集合,一次接口最多40
	 */
	private String assembleOrders;

	/** 
	* 操作类型，支持参数为MERGE、CANCEL_MERGE。当进行CANCEL_MERGE操作时，只需要传入groupId即可，order_list可以为空
	 */
	private String type;

	public void setAssembleOrders(String assembleOrders) {
		this.assembleOrders = assembleOrders;
	}

	public void setAssembleOrders(List<AssembleOrder> assembleOrders) {
		this.assembleOrders = new JSONWriter(false,true).write(assembleOrders);
	}

	public String getAssembleOrders() {
		return this.assembleOrders;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return this.type;
	}

	public String getApiMethodName() {
		return "taobao.fulfillment.order.assemble";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("assemble_orders", this.assembleOrders);
		txtParams.put("type", this.type);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FulfillmentOrderAssembleResponse> getResponseClass() {
		return FulfillmentOrderAssembleResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(type, "type");
	}
	
	/**
 * 合单订单列表，一个列表最多200
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderGroup extends TaobaoObject {

	private static final long serialVersionUID = 5162639565974662968L;

	/**
		 * erp系统内的订单id
		 */
		@ApiField("erp_order_id")
		private String erpOrderId;
		/**
		 * 商品类型, 0:下单货品，1:赠品，2:其他
		 */
		@ApiField("item_type")
		private Long itemType;
		/**
		 * 淘宝单号可以是交易订单、换货单、补货单、代发单或分销单等，当 order_type=0时，order_id =  taobao_parent_order_id。
		 */
		@ApiField("order_id")
		private String orderId;
		/**
		 * order_id的类型，0:淘宝交易订单,1: 换货单,2:分销单，3:补货单，4:代发单
		 */
		@ApiField("order_type")
		private Long orderType;
		/**
		 * 淘宝交易主订单id
		 */
		@ApiField("taobao_parent_order_id")
		private String taobaoParentOrderId;
		/**
		 * 淘宝交易子订单id
		 */
		@ApiField("taobao_sub_order_id")
		private String taobaoSubOrderId;
	

	public String getErpOrderId() {
			return this.erpOrderId;
		}
		public void setErpOrderId(String erpOrderId) {
			this.erpOrderId = erpOrderId;
		}
		public Long getItemType() {
			return this.itemType;
		}
		public void setItemType(Long itemType) {
			this.itemType = itemType;
		}
		public String getOrderId() {
			return this.orderId;
		}
		public void setOrderId(String orderId) {
			this.orderId = orderId;
		}
		public Long getOrderType() {
			return this.orderType;
		}
		public void setOrderType(Long orderType) {
			this.orderType = orderType;
		}
		public String getTaobaoParentOrderId() {
			return this.taobaoParentOrderId;
		}
		public void setTaobaoParentOrderId(String taobaoParentOrderId) {
			this.taobaoParentOrderId = taobaoParentOrderId;
		}
		public String getTaobaoSubOrderId() {
			return this.taobaoSubOrderId;
		}
		public void setTaobaoSubOrderId(String taobaoSubOrderId) {
			this.taobaoSubOrderId = taobaoSubOrderId;
		}

}

	/**
 * 批量回传集合,一次接口最多40
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AssembleOrder extends TaobaoObject {

	private static final long serialVersionUID = 2596117724341727274L;

	/**
		 * 组合id，服务商内部的合单操作id，取消合单会根据group_id进行删除操作。
		 */
		@ApiField("group_id")
		private String groupId;
		/**
		 * 合单订单列表，一个列表最多200
		 */
		@ApiListField("order_list")
		@ApiField("order_group")
		private List<OrderGroup> orderList;
	

	public String getGroupId() {
			return this.groupId;
		}
		public void setGroupId(String groupId) {
			this.groupId = groupId;
		}
		public List<OrderGroup> getOrderList() {
			return this.orderList;
		}
		public void setOrderList(List<OrderGroup> orderList) {
			this.orderList = orderList;
		}

}


}