package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.ItemCatpropsModificationGetResponse;

/**
 * TOP API: taobao.item.catprops.modification.get request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class ItemCatpropsModificationGetRequest extends BaseTaobaoRequest<ItemCatpropsModificationGetResponse> {
	
	

	/** 
	* 类目Id（与商品Id二选一即可）
	 */
	private Long categoryId;

	/** 
	* 商品Id（与类目Id二选一即可。若同时传入商品Id和类目Id，则优先使用商品Id。若填写商品Id，则起始时间设为该商品最近修改时间）
	 */
	private String itemId;

	/** 
	* 起始请求时间（建议传入，默认为90天内）
	 */
	private String startTime;

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public Long getCategoryId() {
		return this.categoryId;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getItemId() {
		return this.itemId;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getStartTime() {
		return this.startTime;
	}

	public String getApiMethodName() {
		return "taobao.item.catprops.modification.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("category_id", this.categoryId);
		txtParams.put("item_id", this.itemId);
		txtParams.put("start_time", this.startTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<ItemCatpropsModificationGetResponse> getResponseClass() {
		return ItemCatpropsModificationGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}