package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.RefundDetailGetResponse;

/**
 * TOP API: taobao.refund.detail.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.24
 */
public class RefundDetailGetRequest extends BaseTaobaoRequest<RefundDetailGetResponse> {
	
	

	/** 
	* 需要返回的字段。目前支持有：allowedOperations,refund_version
	 */
	private String fields;

	/** 
	* 退款编号
	 */
	private Long refundId;

	public void setFields(String fields) {
		this.fields = fields;
	}

	public String getFields() {
		return this.fields;
	}

	public void setRefundId(Long refundId) {
		this.refundId = refundId;
	}

	public Long getRefundId() {
		return this.refundId;
	}

	public String getApiMethodName() {
		return "taobao.refund.detail.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("fields", this.fields);
		txtParams.put("refund_id", this.refundId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<RefundDetailGetResponse> getResponseClass() {
		return RefundDetailGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(fields, "fields");
		RequestCheckUtils.checkNotEmpty(refundId, "refundId");
	}
	

}