package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.RpRefundInterceptResponse;

/**
 * TOP API: taobao.rp.refund.intercept request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.24
 */
public class RpRefundInterceptRequest extends BaseTaobaoRequest<RpRefundInterceptResponse> {
	
	

	/** 
	* 退款编号
	 */
	private Long refundId;

	/** 
	* 退款版本号
	 */
	private Long refundVersion;

	public void setRefundId(Long refundId) {
		this.refundId = refundId;
	}

	public Long getRefundId() {
		return this.refundId;
	}

	public void setRefundVersion(Long refundVersion) {
		this.refundVersion = refundVersion;
	}

	public Long getRefundVersion() {
		return this.refundVersion;
	}

	public String getApiMethodName() {
		return "taobao.rp.refund.intercept";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("refund_id", this.refundId);
		txtParams.put("refund_version", this.refundVersion);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<RpRefundInterceptResponse> getResponseClass() {
		return RpRefundInterceptResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(refundId, "refundId");
		RequestCheckUtils.checkNotEmpty(refundVersion, "refundVersion");
	}
	

}