package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallChannelProductsQueryResponse;

/**
 * TOP API: tmall.channel.products.query request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.01
 */
public class TmallChannelProductsQueryRequest extends BaseTaobaoRequest<TmallChannelProductsQueryResponse> {
	
	

	/** 
	* 页码数，从1开始
	 */
	private Long pageNum;

	/** 
	* 分页大小
	 */
	private Long pageSize;

	/** 
	* 产品Id
	 */
	private String productIds;

	/** 
	* 产品线Id
	 */
	private Long productLineId;

	/** 
	* 商家产品编码
	 */
	private String productNumber;

	/** 
	* 商家SKU编码
	 */
	private String skuNumber;

	public void setPageNum(Long pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageNum() {
		return this.pageNum;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setProductIds(String productIds) {
		this.productIds = productIds;
	}

	public String getProductIds() {
		return this.productIds;
	}

	public void setProductLineId(Long productLineId) {
		this.productLineId = productLineId;
	}

	public Long getProductLineId() {
		return this.productLineId;
	}

	public void setProductNumber(String productNumber) {
		this.productNumber = productNumber;
	}

	public String getProductNumber() {
		return this.productNumber;
	}

	public void setSkuNumber(String skuNumber) {
		this.skuNumber = skuNumber;
	}

	public String getSkuNumber() {
		return this.skuNumber;
	}

	public String getApiMethodName() {
		return "tmall.channel.products.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("page_num", this.pageNum);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("product_ids", this.productIds);
		txtParams.put("product_line_id", this.productLineId);
		txtParams.put("product_number", this.productNumber);
		txtParams.put("sku_number", this.skuNumber);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelProductsQueryResponse> getResponseClass() {
		return TmallChannelProductsQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(pageNum, "pageNum");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkMaxListSize(productIds, 20, "productIds");
	}
	

}