package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TopOnceTokenGetResponse;

/**
 * TOP API: taobao.top.once.token.get request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.24
 */
public class TopOnceTokenGetRequest extends BaseTaobaoRequest<TopOnceTokenGetResponse> {
	
	

	/** 
	* sec_token
	 */
	private String secToken;

	public void setSecToken(String secToken) {
		this.secToken = secToken;
	}

	public String getSecToken() {
		return this.secToken;
	}

	public String getApiMethodName() {
		return "taobao.top.once.token.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("sec_token", this.secToken);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TopOnceTokenGetResponse> getResponseClass() {
		return TopOnceTokenGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(secToken, "secToken");
	}
	

}