package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.einvoice.create.result.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaEinvoiceCreateResultGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1661741723921879941L;

	/** 
	 * 开票返回结果数据列表
	 */
	@ApiListField("invoice_result_list")
	@ApiField("invoice_result")
	private List<InvoiceResult> invoiceResultList;


	public void setInvoiceResultList(List<InvoiceResult> invoiceResultList) {
		this.invoiceResultList = invoiceResultList;
	}
	public List<InvoiceResult> getInvoiceResultList( ) {
		return this.invoiceResultList;
	}
	
	/**
 * 电子发票明细，erp开票默认不返回，如果erp需要获取阿里发票平台自动开票的结果，需要先找阿里小二开通权限
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InvoiceItem extends TaobaoObject {

	private static final long serialVersionUID = 6437293194691387937L;

	/**
		 * 价税合计。(等于sumPrice和tax之和)
		 */
		@ApiField("amount")
		private String amount;
		/**
		 * 淘宝子订单号，阿里发票平台自动开票时才有
		 */
		@ApiField("biz_order_id")
		private String bizOrderId;
		/**
		 * 是否为运费行，，阿里发票平台自动开票时才有
		 */
		@ApiField("is_post_fee_row")
		private Boolean isPostFeeRow;
		/**
		 * 发票项目名称（或商品名称）
		 */
		@ApiField("item_name")
		private String itemName;
		/**
		 * 税收分类编码
		 */
		@ApiField("item_no")
		private String itemNo;
		/**
		 * 商品的外部系统id，如果有sku则取sku的outerId，否则取item的outerId，，阿里发票平台自动开票时才有
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 单价，格式：100.00(不含税)
		 */
		@ApiField("price")
		private String price;
		/**
		 * 数量
		 */
		@ApiField("quantity")
		private String quantity;
		/**
		 * 发票行性质。0表示正常行，1表示折扣行，2表示被折扣行。比如充电器单价100元，折扣10元，则明细为2行，充电器行性质为2，折扣行性质为1。如果充电器没有折扣，则值应为0
		 */
		@ApiField("row_type")
		private String rowType;
		/**
		 * 规格型号,可选
		 */
		@ApiField("specification")
		private String specification;
		/**
		 * 总价，格式：100.00(不含税)
		 */
		@ApiField("sum_price")
		private String sumPrice;
		/**
		 * 税额
		 */
		@ApiField("tax")
		private String tax;
		/**
		 * 税率。税率只能为0或0.03或0.04或0.06或0.11或0.13或0.17
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 单位
		 */
		@ApiField("unit")
		private String unit;
		/**
		 * 0税率标识，0=出口零税率，1=免税，2=不征收，3=普通零税率
		 */
		@ApiField("zero_rate_flag")
		private String zeroRateFlag;
	

	public String getAmount() {
			return this.amount;
		}
		public void setAmount(String amount) {
			this.amount = amount;
		}
		public String getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(String bizOrderId) {
			this.bizOrderId = bizOrderId;
		}
		public Boolean getIsPostFeeRow() {
			return this.isPostFeeRow;
		}
		public void setIsPostFeeRow(Boolean isPostFeeRow) {
			this.isPostFeeRow = isPostFeeRow;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public String getItemNo() {
			return this.itemNo;
		}
		public void setItemNo(String itemNo) {
			this.itemNo = itemNo;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getQuantity() {
			return this.quantity;
		}
		public void setQuantity(String quantity) {
			this.quantity = quantity;
		}
		public String getRowType() {
			return this.rowType;
		}
		public void setRowType(String rowType) {
			this.rowType = rowType;
		}
		public String getSpecification() {
			return this.specification;
		}
		public void setSpecification(String specification) {
			this.specification = specification;
		}
		public String getSumPrice() {
			return this.sumPrice;
		}
		public void setSumPrice(String sumPrice) {
			this.sumPrice = sumPrice;
		}
		public String getTax() {
			return this.tax;
		}
		public void setTax(String tax) {
			this.tax = tax;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getUnit() {
			return this.unit;
		}
		public void setUnit(String unit) {
			this.unit = unit;
		}
		public String getZeroRateFlag() {
			return this.zeroRateFlag;
		}
		public void setZeroRateFlag(String zeroRateFlag) {
			this.zeroRateFlag = zeroRateFlag;
		}

}

	/**
 * 开票返回结果数据列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InvoiceResult extends TaobaoObject {

	private static final long serialVersionUID = 4851638675435494844L;

	/**
		 * 防伪码
		 */
		@ApiField("anti_fake_code")
		private String antiFakeCode;
		/**
		 * 错误编码
		 */
		@ApiField("biz_error_code")
		private String bizErrorCode;
		/**
		 * 错误信息
		 */
		@ApiField("biz_error_msg")
		private String bizErrorMsg;
		/**
		 * 发票密文，密码区的字符串
		 */
		@ApiField("ciphertext")
		private String ciphertext;
		/**
		 * 税控设备编号(新版电子发票有)
		 */
		@ApiField("device_no")
		private String deviceNo;
		/**
		 * erp自定义单据号
		 */
		@ApiField("erp_tid")
		private String erpTid;
		/**
		 * 文件类型(pdf,jpg,png)
		 */
		@ApiField("file_data_type")
		private String fileDataType;
		/**
		 * 发票PDF的下载地址(仅在单个查询接口上显示，批量查询不显示)
		 */
		@ApiField("file_path")
		private String filePath;
		/**
		 * 开票金额
		 */
		@ApiField("invoice_amount")
		private String invoiceAmount;
		/**
		 * 发票代码
		 */
		@ApiField("invoice_code")
		private String invoiceCode;
		/**
		 * 开票日期
		 */
		@ApiField("invoice_date")
		private String invoiceDate;
		/**
		 * 电子发票明细，erp开票默认不返回，如果erp需要获取阿里发票平台自动开票的结果，需要先找阿里小二开通权限
		 */
		@ApiListField("invoice_items")
		@ApiField("invoice_item")
		private List<InvoiceItem> invoiceItems;
		/**
		 * 发票种类，0=电子发票，1=纸质发票，2=纸质专票
		 */
		@ApiField("invoice_kind")
		private Long invoiceKind;
		/**
		 * 发票号码
		 */
		@ApiField("invoice_no")
		private String invoiceNo;
		/**
		 * 开票时间，时分秒格式（注意：2019-04-11之后开具的发票才返回）
		 */
		@ApiField("invoice_time")
		private String invoiceTime;
		/**
		 * 发票类型，blue=蓝票，red=红票
		 */
		@ApiField("invoice_type")
		private String invoiceType;
		/**
		 * 原蓝票发票代码，invoiceType=red时有值
		 */
		@ApiField("normal_invoice_code")
		private String normalInvoiceCode;
		/**
		 * 原蓝票发票号码，invoiceType=red时有值
		 */
		@ApiField("normal_invoice_no")
		private String normalInvoiceNo;
		/**
		 * 复核人，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payee_checker")
		private String payeeChecker;
		/**
		 * 销售方企业名称
		 */
		@ApiField("payee_name")
		private String payeeName;
		/**
		 * 开票人，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payee_operator")
		private String payeeOperator;
		/**
		 * 收款人，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payee_receiver")
		private String payeeReceiver;
		/**
		 * 销售方税号
		 */
		@ApiField("payee_register_no")
		private String payeeRegisterNo;
		/**
		 * 购买方企业地址，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payer_address")
		private String payerAddress;
		/**
		 * 购买方企业银行及账号，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payer_bankaccount")
		private String payerBankaccount;
		/**
		 * 购买方抬头，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payer_name")
		private String payerName;
		/**
		 * 购买方企业电话，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payer_phone")
		private String payerPhone;
		/**
		 * 购买方税号，erp开票不返回，用来erp获取自动开票结果
		 */
		@ApiField("payer_register_no")
		private String payerRegisterNo;
		/**
		 * 电商平台代码。淘宝：taobao，天猫：tmall
		 */
		@ApiField("platform_code")
		private String platformCode;
		/**
		 * 电商平台订单号
		 */
		@ApiField("platform_tid")
		private String platformTid;
		/**
		 * 开票流水号，唯一标志开票请求。如果两次请求流水号相同，则表示重复请求。
		 */
		@ApiField("serial_no")
		private String serialNo;
		/**
		 * 开票状态 (waiting = 开票中) 、(create_success = 开票成功)、(create_failed = 开票失败)
		 */
		@ApiField("status")
		private String status;
	

	public String getAntiFakeCode() {
			return this.antiFakeCode;
		}
		public void setAntiFakeCode(String antiFakeCode) {
			this.antiFakeCode = antiFakeCode;
		}
		public String getBizErrorCode() {
			return this.bizErrorCode;
		}
		public void setBizErrorCode(String bizErrorCode) {
			this.bizErrorCode = bizErrorCode;
		}
		public String getBizErrorMsg() {
			return this.bizErrorMsg;
		}
		public void setBizErrorMsg(String bizErrorMsg) {
			this.bizErrorMsg = bizErrorMsg;
		}
		public String getCiphertext() {
			return this.ciphertext;
		}
		public void setCiphertext(String ciphertext) {
			this.ciphertext = ciphertext;
		}
		public String getDeviceNo() {
			return this.deviceNo;
		}
		public void setDeviceNo(String deviceNo) {
			this.deviceNo = deviceNo;
		}
		public String getErpTid() {
			return this.erpTid;
		}
		public void setErpTid(String erpTid) {
			this.erpTid = erpTid;
		}
		public String getFileDataType() {
			return this.fileDataType;
		}
		public void setFileDataType(String fileDataType) {
			this.fileDataType = fileDataType;
		}
		public String getFilePath() {
			return this.filePath;
		}
		public void setFilePath(String filePath) {
			this.filePath = filePath;
		}
		public String getInvoiceAmount() {
			return this.invoiceAmount;
		}
		public void setInvoiceAmount(String invoiceAmount) {
			this.invoiceAmount = invoiceAmount;
		}
		public String getInvoiceCode() {
			return this.invoiceCode;
		}
		public void setInvoiceCode(String invoiceCode) {
			this.invoiceCode = invoiceCode;
		}
		public String getInvoiceDate() {
			return this.invoiceDate;
		}
		public void setInvoiceDate(String invoiceDate) {
			this.invoiceDate = invoiceDate;
		}
		public List<InvoiceItem> getInvoiceItems() {
			return this.invoiceItems;
		}
		public void setInvoiceItems(List<InvoiceItem> invoiceItems) {
			this.invoiceItems = invoiceItems;
		}
		public Long getInvoiceKind() {
			return this.invoiceKind;
		}
		public void setInvoiceKind(Long invoiceKind) {
			this.invoiceKind = invoiceKind;
		}
		public String getInvoiceNo() {
			return this.invoiceNo;
		}
		public void setInvoiceNo(String invoiceNo) {
			this.invoiceNo = invoiceNo;
		}
		public String getInvoiceTime() {
			return this.invoiceTime;
		}
		public void setInvoiceTime(String invoiceTime) {
			this.invoiceTime = invoiceTime;
		}
		public String getInvoiceType() {
			return this.invoiceType;
		}
		public void setInvoiceType(String invoiceType) {
			this.invoiceType = invoiceType;
		}
		public String getNormalInvoiceCode() {
			return this.normalInvoiceCode;
		}
		public void setNormalInvoiceCode(String normalInvoiceCode) {
			this.normalInvoiceCode = normalInvoiceCode;
		}
		public String getNormalInvoiceNo() {
			return this.normalInvoiceNo;
		}
		public void setNormalInvoiceNo(String normalInvoiceNo) {
			this.normalInvoiceNo = normalInvoiceNo;
		}
		public String getPayeeChecker() {
			return this.payeeChecker;
		}
		public void setPayeeChecker(String payeeChecker) {
			this.payeeChecker = payeeChecker;
		}
		public String getPayeeName() {
			return this.payeeName;
		}
		public void setPayeeName(String payeeName) {
			this.payeeName = payeeName;
		}
		public String getPayeeOperator() {
			return this.payeeOperator;
		}
		public void setPayeeOperator(String payeeOperator) {
			this.payeeOperator = payeeOperator;
		}
		public String getPayeeReceiver() {
			return this.payeeReceiver;
		}
		public void setPayeeReceiver(String payeeReceiver) {
			this.payeeReceiver = payeeReceiver;
		}
		public String getPayeeRegisterNo() {
			return this.payeeRegisterNo;
		}
		public void setPayeeRegisterNo(String payeeRegisterNo) {
			this.payeeRegisterNo = payeeRegisterNo;
		}
		public String getPayerAddress() {
			return this.payerAddress;
		}
		public void setPayerAddress(String payerAddress) {
			this.payerAddress = payerAddress;
		}
		public String getPayerBankaccount() {
			return this.payerBankaccount;
		}
		public void setPayerBankaccount(String payerBankaccount) {
			this.payerBankaccount = payerBankaccount;
		}
		public String getPayerName() {
			return this.payerName;
		}
		public void setPayerName(String payerName) {
			this.payerName = payerName;
		}
		public String getPayerPhone() {
			return this.payerPhone;
		}
		public void setPayerPhone(String payerPhone) {
			this.payerPhone = payerPhone;
		}
		public String getPayerRegisterNo() {
			return this.payerRegisterNo;
		}
		public void setPayerRegisterNo(String payerRegisterNo) {
			this.payerRegisterNo = payerRegisterNo;
		}
		public String getPlatformCode() {
			return this.platformCode;
		}
		public void setPlatformCode(String platformCode) {
			this.platformCode = platformCode;
		}
		public String getPlatformTid() {
			return this.platformTid;
		}
		public void setPlatformTid(String platformTid) {
			this.platformTid = platformTid;
		}
		public String getSerialNo() {
			return this.serialNo;
		}
		public void setSerialNo(String serialNo) {
			this.serialNo = serialNo;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}

}



}
