package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.einvoice.payout.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaEinvoicePayoutGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3495384911243445315L;

	/** 
	 * 查询结果
	 */
	@ApiField("is_success")
	private Boolean isSuccess;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private OrderRightsResult result;


	public void setIsSuccess(Boolean isSuccess) {
		this.isSuccess = isSuccess;
	}
	public Boolean getIsSuccess( ) {
		return this.isSuccess;
	}

	public void setResult(OrderRightsResult result) {
		this.result = result;
	}
	public OrderRightsResult getResult( ) {
		return this.result;
	}
	
	/**
 * 赔付列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderRightsInfo extends TaobaoObject {

	private static final long serialVersionUID = 2282626531789785926L;

	/**
		 * 订单应开票时间
		 */
		@ApiField("except_invoice_time")
		private String exceptInvoiceTime;
		/**
		 * 订单号
		 */
		@ApiField("tid")
		private String tid;
	

	public String getExceptInvoiceTime() {
			return this.exceptInvoiceTime;
		}
		public void setExceptInvoiceTime(String exceptInvoiceTime) {
			this.exceptInvoiceTime = exceptInvoiceTime;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderRightsResult extends TaobaoObject {

	private static final long serialVersionUID = 8265283637263838856L;

	/**
		 * 赔付列表
		 */
		@ApiListField("payout_list")
		@ApiField("order_rights_info")
		private List<OrderRightsInfo> payoutList;
		/**
		 * 赔付列表总数，超过系统最大展示数量是以200+的格式返回，
		 */
		@ApiField("total_count")
		private String totalCount;
	

	public List<OrderRightsInfo> getPayoutList() {
			return this.payoutList;
		}
		public void setPayoutList(List<OrderRightsInfo> payoutList) {
			this.payoutList = payoutList;
		}
		public String getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(String totalCount) {
			this.totalCount = totalCount;
		}

}



}
