package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.refund.detail.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class RefundDetailGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8513639957454351423L;

	/** 
	 * 退款详情
	 */
	@ApiField("detail")
	private RefundDetail detail;


	public void setDetail(RefundDetail detail) {
		this.detail = detail;
	}
	public RefundDetail getDetail( ) {
		return this.detail;
	}
	
	/**
 * 退款当前可以执行的操作
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Operation extends TaobaoObject {

	private static final long serialVersionUID = 2871547759851161229L;

	/**
		 * 操作编码
		 */
		@ApiField("operation_code")
		private String operationCode;
		/**
		 * 操作提示文案
		 */
		@ApiField("tips")
		private String tips;
	

	public String getOperationCode() {
			return this.operationCode;
		}
		public void setOperationCode(String operationCode) {
			this.operationCode = operationCode;
		}
		public String getTips() {
			return this.tips;
		}
		public void setTips(String tips) {
			this.tips = tips;
		}

}

	/**
 * 退款详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RefundDetail extends TaobaoObject {

	private static final long serialVersionUID = 3397576371823712168L;

	/**
		 * 退款当前可以执行的操作
		 */
		@ApiListField("allowed_operations")
		@ApiField("operation")
		private List<Operation> allowedOperations;
		/**
		 * 退款当前不可以执行的操作
		 */
		@ApiListField("not_allowed_operations")
		@ApiField("operation")
		private List<Operation> notAllowedOperations;
		/**
		 * 退款版本号
		 */
		@ApiField("refund_version")
		private Long refundVersion;
	

	public List<Operation> getAllowedOperations() {
			return this.allowedOperations;
		}
		public void setAllowedOperations(List<Operation> allowedOperations) {
			this.allowedOperations = allowedOperations;
		}
		public List<Operation> getNotAllowedOperations() {
			return this.notAllowedOperations;
		}
		public void setNotAllowedOperations(List<Operation> notAllowedOperations) {
			this.notAllowedOperations = notAllowedOperations;
		}
		public Long getRefundVersion() {
			return this.refundVersion;
		}
		public void setRefundVersion(Long refundVersion) {
			this.refundVersion = refundVersion;
		}

}



}
