package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.channel.products.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallChannelProductsQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7254796988954419641L;

	/** 
	 * result
	 */
	@ApiField("result")
	private PageResultDto result;


	public void setResult(PageResultDto result) {
		this.result = result;
	}
	public PageResultDto getResult( ) {
		return this.result;
	}
	
	/**
 * sku列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ProductSkuTopDto extends TaobaoObject {

	private static final long serialVersionUID = 7649119921594555727L;

	/**
		 * 条形码
		 */
		@ApiField("bar_code")
		private String barCode;
		/**
		 * 图片链接
		 */
		@ApiField("picture_url")
		private String pictureUrl;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
		/**
		 * sku商家编码
		 */
		@ApiField("sku_number")
		private String skuNumber;
		/**
		 * sku后端货品
		 */
		@ApiField("sku_sc_item_id")
		private Long skuScItemId;
		/**
		 * 基准价
		 */
		@ApiField("standard_price")
		private Long standardPrice;
	

	public String getBarCode() {
			return this.barCode;
		}
		public void setBarCode(String barCode) {
			this.barCode = barCode;
		}
		public String getPictureUrl() {
			return this.pictureUrl;
		}
		public void setPictureUrl(String pictureUrl) {
			this.pictureUrl = pictureUrl;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}
		public String getSkuNumber() {
			return this.skuNumber;
		}
		public void setSkuNumber(String skuNumber) {
			this.skuNumber = skuNumber;
		}
		public Long getSkuScItemId() {
			return this.skuScItemId;
		}
		public void setSkuScItemId(Long skuScItemId) {
			this.skuScItemId = skuScItemId;
		}
		public Long getStandardPrice() {
			return this.standardPrice;
		}
		public void setStandardPrice(Long standardPrice) {
			this.standardPrice = standardPrice;
		}

}

	/**
 * 产品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ProductTopDto extends TaobaoObject {

	private static final long serialVersionUID = 4522191954622892912L;

	/**
		 * 类目Id
		 */
		@ApiField("category_id")
		private Long categoryId;
		/**
		 * 产品描述地址
		 */
		@ApiField("desc_path")
		private String descPath;
		/**
		 * 产品Id
		 */
		@ApiField("product_id")
		private Long productId;
		/**
		 * 产品线ID
		 */
		@ApiField("product_line_id")
		private Long productLineId;
		/**
		 * 产品编码
		 */
		@ApiField("product_number")
		private String productNumber;
		/**
		 * 没有sku的情况下，产品对应的后端商品id
		 */
		@ApiField("sc_item_id")
		private Long scItemId;
		/**
		 * sku列表
		 */
		@ApiListField("sku_list")
		@ApiField("product_sku_top_dto")
		private List<ProductSkuTopDto> skuList;
		/**
		 * spuId
		 */
		@ApiField("spu_id")
		private Long spuId;
		/**
		 * 基准价
		 */
		@ApiField("standard_price")
		private Long standardPrice;
		/**
		 * 供应商Id
		 */
		@ApiField("supplier_id")
		private Long supplierId;
		/**
		 * 标题
		 */
		@ApiField("title")
		private String title;
	

	public Long getCategoryId() {
			return this.categoryId;
		}
		public void setCategoryId(Long categoryId) {
			this.categoryId = categoryId;
		}
		public String getDescPath() {
			return this.descPath;
		}
		public void setDescPath(String descPath) {
			this.descPath = descPath;
		}
		public Long getProductId() {
			return this.productId;
		}
		public void setProductId(Long productId) {
			this.productId = productId;
		}
		public Long getProductLineId() {
			return this.productLineId;
		}
		public void setProductLineId(Long productLineId) {
			this.productLineId = productLineId;
		}
		public String getProductNumber() {
			return this.productNumber;
		}
		public void setProductNumber(String productNumber) {
			this.productNumber = productNumber;
		}
		public Long getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(Long scItemId) {
			this.scItemId = scItemId;
		}
		public List<ProductSkuTopDto> getSkuList() {
			return this.skuList;
		}
		public void setSkuList(List<ProductSkuTopDto> skuList) {
			this.skuList = skuList;
		}
		public Long getSpuId() {
			return this.spuId;
		}
		public void setSpuId(Long spuId) {
			this.spuId = spuId;
		}
		public Long getStandardPrice() {
			return this.standardPrice;
		}
		public void setStandardPrice(Long standardPrice) {
			this.standardPrice = standardPrice;
		}
		public Long getSupplierId() {
			return this.supplierId;
		}
		public void setSupplierId(Long supplierId) {
			this.supplierId = supplierId;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}

}

	/**
 * result
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PageResultDto extends TaobaoObject {

	private static final long serialVersionUID = 2369658792483567788L;

	/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 异常信息
		 */
		@ApiField("error_message")
		private String errorMessage;
		/**
		 * 是否有下一页
		 */
		@ApiField("has_next")
		private Boolean hasNext;
		/**
		 * 产品信息
		 */
		@ApiListField("product_list")
		@ApiField("product_top_dto")
		private List<ProductTopDto> productList;
		/**
		 * 是否查询成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 总数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorMessage() {
			return this.errorMessage;
		}
		public void setErrorMessage(String errorMessage) {
			this.errorMessage = errorMessage;
		}
		public Boolean getHasNext() {
			return this.hasNext;
		}
		public void setHasNext(Boolean hasNext) {
			this.hasNext = hasNext;
		}
		public List<ProductTopDto> getProductList() {
			return this.productList;
		}
		public void setProductList(List<ProductTopDto> productList) {
			this.productList = productList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
