/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TopOaidClientDecryptResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopOaidClientDecryptRequest
extends BaseTaobaoRequest<TopOaidClientDecryptResponse> {
    private String queryList;
    private String secOnceToken;

    public void setQueryList(String queryList) {
        this.queryList = queryList;
    }

    public void setQueryList(List<ReceiverQuery> queryList) {
        this.queryList = new JSONWriter(false, true).write(queryList);
    }

    public String getQueryList() {
        return this.queryList;
    }

    public void setSecOnceToken(String secOnceToken) {
        this.secOnceToken = secOnceToken;
    }

    public String getSecOnceToken() {
        return this.secOnceToken;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.top.oaid.client.decrypt";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("query_list", this.queryList);
        txtParams.put("sec_once_token", this.secOnceToken);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TopOaidClientDecryptResponse> getResponseClass() {
        return TopOaidClientDecryptResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.queryList, 999, "queryList");
        RequestCheckUtils.checkNotEmpty(this.secOnceToken, "secOnceToken");
    }

    public static class ReceiverQuery
    extends TaobaoObject {
        private static final long serialVersionUID = 1844977145193496845L;
        @ApiField(value="oaid")
        private String oaid;
        @ApiField(value="scene")
        private String scene;
        @ApiField(value="secret_no_days")
        private Long secretNoDays;
        @ApiField(value="tid")
        private String tid;

        public String getOaid() {
            return this.oaid;
        }

        public void setOaid(String oaid) {
            this.oaid = oaid;
        }

        public String getScene() {
            return this.scene;
        }

        public void setScene(String scene) {
            this.scene = scene;
        }

        public Long getSecretNoDays() {
            return this.secretNoDays;
        }

        public void setSecretNoDays(Long secretNoDays) {
            this.secretNoDays = secretNoDays;
        }

        public String getTid() {
            return this.tid;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }
    }
}

