/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.domain.PromotionDetail;
import com.taobao.api.domain.Trade;
import com.taobao.api.request.TopOaidDecryptRequest;
import com.taobao.api.request.TradeFullinfoGetRequest;
import com.taobao.api.request.TradesSoldIncrementGetRequest;
import com.taobao.api.response.TopOaidDecryptResponse;
import com.taobao.api.response.TradeFullinfoGetResponse;
import com.taobao.api.response.TradesSoldIncrementGetResponse;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.qihangec.open.tao.OrderAssembleHelper;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.domain.TaoOrder;
import tech.qihangec.open.tao.domain.TaoOrderPromotion;

public class OrderApiHelper {
    private static Logger log = LoggerFactory.getLogger(OrderApiHelper.class);
    private static final String ORDER_List_FIELDS = "tid,receiver_name,receiver_country,receiver_state,receiver_city,receiver_district,receiver_town,receiver_address,receiver_mobile,receiver_phone,title,seller_flag,has_buyer_message,credit_card_fee,mark_desc,consign_time,end_time,sid,yfx_fee,has_yfx,type,status,orders,rx_audit_status,seller_memo,buyer_memo,buyer_message,pay_time,created,modified,buyer_nick,buyer_open_uid,alipay_no,buyer_alipay_no,buyer_email,num_iid,num,price,total_fee,adjust_fee,post_fee,discount_fee,payment,received_payment,available_confirm_fee,commission_fee,oaid,promotion_details,tmall_coupon_fee,logistics_company,invoice_no";
    private static final String ORDER_DETAIL_FIELDS = "tid,receiver_name,receiver_country,receiver_state,receiver_city,receiver_district,receiver_town,receiver_address,receiver_mobile,receiver_phone,title,seller_flag,has_buyer_message,credit_card_fee,mark_desc,consign_time,end_time,sid,yfx_fee,has_yfx,type,status,orders,rx_audit_status,seller_memo,buyer_memo,buyer_message,pay_time,created,modified,buyer_nick,buyer_open_uid,alipay_no,buyer_alipay_no,buyer_email,num_iid,num,price,total_fee,adjust_fee,post_fee,discount_fee,payment,received_payment,available_confirm_fee,commission_fee,oaid,promotion_details,tmall_coupon_fee,logistics_infos,LogisticsInfos,logistics_company,invoice_no";

    protected static ApiResultVo<TaoOrder> pullIncrementOrder(LocalDateTime startTime, LocalDateTime endTime, Long pageNo, Long pageSize, String url, String appKey, String appSecret, String sessionKey) throws ApiException, InvocationTargetException, IllegalAccessException {
        TaoOrder taoOrder;
        TopOaidDecryptRequest.ReceiverQuery obj2;
        ArrayList<TopOaidDecryptRequest.ReceiverQuery> list2;
        Long req2;
        String startTimeStr = startTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTimeStr = endTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        log.info("=======\u5f00\u59cb\u5168\u91cf\u62c9\u53d6TAO\u8ba2\u5355{}\uff0c\u53c2\u6570\u65e5\u671f\uff1a{}-{}=========", new Object[]{LocalDateTime.now(), startTimeStr, endTimeStr});
        DefaultTaobaoClient client = new DefaultTaobaoClient(url, appKey, appSecret);
        TradesSoldIncrementGetRequest req = new TradesSoldIncrementGetRequest();
        req.setFields(ORDER_List_FIELDS);
        req.setStartModified(Date.from(startTime.toInstant(ZoneOffset.UTC)));
        req.setEndModified(Date.from(endTime.toInstant(ZoneOffset.UTC)));
        req.setType("fixed");
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        req.setUseHasNext(Boolean.valueOf(true));
        TradesSoldIncrementGetResponse rsp = (TradesSoldIncrementGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        if (rsp.getTrades() == null) {
            if (!StringUtils.isEmpty(rsp.getErrorCode())) {
                return ApiResultVo.error(500, "\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff1a" + rsp.getMsg() + rsp.getSubMsg());
            }
            log.info("========\u589e\u91cf\u62c9\u53d6\u8ba2\u5355\uff1a\u65e0\u8ba2\u5355,{}==========", (Object)LocalDateTime.now());
            return ApiResultVo.success(0, new ArrayList());
        }
        ArrayList<TaoOrder> orderList = new ArrayList<TaoOrder>();
        if (rsp.getTrades() != null && !rsp.getTrades().isEmpty()) {
            req2 = new TopOaidDecryptRequest();
            list2 = new ArrayList<TopOaidDecryptRequest.ReceiverQuery>();
            obj2 = new TopOaidDecryptRequest.ReceiverQuery();
            list2.add(obj2);
            obj2.setScene("1005");
            obj2.setSecretNoDays(Long.valueOf(15L));
            for (Trade tradeTmp : rsp.getTrades()) {
                taoOrder = OrderAssembleHelper.assembleOrder(tradeTmp);
                TradeFullinfoGetRequest reqDetail = new TradeFullinfoGetRequest();
                reqDetail.setFields(ORDER_DETAIL_FIELDS);
                reqDetail.setTid(tradeTmp.getTid());
                TradeFullinfoGetResponse rspDetail = (TradeFullinfoGetResponse)client.execute((TaobaoRequest)reqDetail, sessionKey);
                Trade trade = rspDetail.getTrade();
                if (trade != null) {
                    ArrayList<TaoOrderPromotion> promotions = new ArrayList<TaoOrderPromotion>();
                    if (trade.getTmallCouponFee() != null) {
                        taoOrder.setTmallCouponFee(trade.getTmallCouponFee());
                        TaoOrderPromotion promo = new TaoOrderPromotion();
                        promo.setId(trade.getTid());
                        promo.setDiscountFee("" + trade.getTmallCouponFee().doubleValue() / 100.0);
                        promo.setPromotionName("\u5929\u732b\u8ba2\u5355\u7ea2\u5305");
                        promo.setPromotionDesc("\u5929\u732b\u8ba2\u5355\u4f7f\u7528\u7684\u7ea2\u5305\u4fe1\u606f");
                        promotions.add(promo);
                    }
                    if (trade.getPromotionDetails() != null) {
                        for (PromotionDetail p : trade.getPromotionDetails()) {
                            TaoOrderPromotion promotion = new TaoOrderPromotion();
                            BeanUtils.copyProperties(p, promotion);
                            promotions.add(promotion);
                        }
                        taoOrder.setPromotions(promotions);
                    }
                    obj2.setOaid(trade.getOaid());
                    obj2.setTid(trade.getTid().toString());
                    req2.setQueryList(list2);
                    TopOaidDecryptResponse rsp2 = (TopOaidDecryptResponse)client.execute((TaobaoRequest)req2, sessionKey);
                    if (rsp2.getReceiverList() != null && !rsp2.getReceiverList().isEmpty()) {
                        taoOrder.setReceiverName(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getName());
                        taoOrder.setReceiverAddress(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getAddressDetail());
                        taoOrder.setReceiverMobile(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getMobile());
                    } else {
                        log.info("\u6dd8\u5b9d\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff1a" + rsp2.getSubMsg());
                    }
                    orderList.add(taoOrder);
                    continue;
                }
                log.info("TAO\u8ba2\u5355\u8be6\u60c5\u63a5\u53e3\u83b7\u53d6\u9519\u8bef" + tradeTmp.getTid() + rspDetail.getSubMsg());
            }
        }
        while (rsp.getHasNext().booleanValue()) {
            req2 = pageNo;
            pageNo = pageNo + 1L;
            req.setPageNo(pageNo);
            rsp = (TradesSoldIncrementGetResponse)client.execute((TaobaoRequest)req, sessionKey);
            if (rsp.getTrades() == null || rsp.getTrades().isEmpty()) continue;
            req2 = new TopOaidDecryptRequest();
            list2 = new ArrayList();
            obj2 = new TopOaidDecryptRequest.ReceiverQuery();
            list2.add(obj2);
            obj2.setScene("1005");
            obj2.setSecretNoDays(Long.valueOf(15L));
            for (Trade trade : rsp.getTrades()) {
                taoOrder = OrderAssembleHelper.assembleOrder(trade);
                obj2.setOaid(trade.getOaid());
                obj2.setTid(trade.getTid().toString());
                req2.setQueryList(list2);
                TopOaidDecryptResponse rsp2 = (TopOaidDecryptResponse)client.execute((TaobaoRequest)req2, sessionKey);
                if (rsp2.getReceiverList() != null && !rsp2.getReceiverList().isEmpty()) {
                    taoOrder.setReceiverName(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getName());
                    taoOrder.setReceiverAddress(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getAddressDetail());
                    taoOrder.setReceiverMobile(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getMobile());
                }
                orderList.add(taoOrder);
            }
        }
        return ApiResultVo.success(orderList.size(), orderList);
    }

    protected static ApiResultVo<TaoOrder> pullOrderDetail(Long tid, String url, String appKey, String appSecret, String sessionKey) throws ApiException, InvocationTargetException, IllegalAccessException {
        log.info("=======\u5f00\u59cb\u62c9\u53d6TAO\u8ba2\u5355\u8be6\u60c5{}\uff0c", (Object)LocalDateTime.now());
        DefaultTaobaoClient client = new DefaultTaobaoClient(url, appKey, appSecret);
        TradeFullinfoGetRequest reqDetail = new TradeFullinfoGetRequest();
        reqDetail.setFields(ORDER_DETAIL_FIELDS);
        reqDetail.setTid(tid);
        TradeFullinfoGetResponse rspDetail = (TradeFullinfoGetResponse)client.execute((TaobaoRequest)reqDetail, sessionKey);
        Trade trade = rspDetail.getTrade();
        if (trade != null) {
            TaoOrder taoOrder = OrderAssembleHelper.assembleOrder(trade);
            ArrayList<TaoOrderPromotion> promotions = new ArrayList<TaoOrderPromotion>();
            if (trade.getTmallCouponFee() != null) {
                taoOrder.setTmallCouponFee(trade.getTmallCouponFee());
                TaoOrderPromotion promo = new TaoOrderPromotion();
                promo.setId(trade.getTid());
                promo.setDiscountFee("" + trade.getTmallCouponFee().doubleValue() / 100.0);
                promo.setPromotionName("\u5929\u732b\u8ba2\u5355\u7ea2\u5305");
                promo.setPromotionDesc("\u5929\u732b\u8ba2\u5355\u4f7f\u7528\u7684\u7ea2\u5305\u4fe1\u606f");
                promotions.add(promo);
            }
            if (trade.getPromotionDetails() != null) {
                for (PromotionDetail p : trade.getPromotionDetails()) {
                    TaoOrderPromotion promotion = new TaoOrderPromotion();
                    BeanUtils.copyProperties(p, promotion);
                    promotions.add(promotion);
                }
                taoOrder.setPromotions(promotions);
            }
            TopOaidDecryptRequest req2 = new TopOaidDecryptRequest();
            ArrayList<TopOaidDecryptRequest.ReceiverQuery> list2 = new ArrayList<TopOaidDecryptRequest.ReceiverQuery>();
            TopOaidDecryptRequest.ReceiverQuery obj2 = new TopOaidDecryptRequest.ReceiverQuery();
            list2.add(obj2);
            obj2.setScene("1005");
            obj2.setSecretNoDays(Long.valueOf(15L));
            obj2.setOaid(trade.getOaid());
            obj2.setTid(trade.getTid().toString());
            req2.setQueryList(list2);
            TopOaidDecryptResponse rsp2 = (TopOaidDecryptResponse)client.execute((TaobaoRequest)req2, sessionKey);
            if (rsp2.getReceiverList() != null && !rsp2.getReceiverList().isEmpty()) {
                taoOrder.setReceiverName(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getName());
                taoOrder.setReceiverAddress(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getAddressDetail());
                taoOrder.setReceiverMobile(((TopOaidDecryptResponse.Receiver)rsp2.getReceiverList().get(0)).getMobile());
            }
            return ApiResultVo.success(taoOrder);
        }
        String msg = "TAO\u8ba2\u5355\u8be6\u60c5\u63a5\u53e3\u83b7\u53d6\u9519\u8bef" + tid + rspDetail.getSubMsg();
        log.info(msg);
        return ApiResultVo.error(ApiResultVoEnum.SystemException, msg);
    }
}

