/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao.common;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PageQuery
implements Serializable {
    private Integer pageSize;
    private Integer pageNum;
    private String orderByColumn;
    private String isAsc;
    public static final int DEFAULT_PAGE_INDEX = 1;
    public static final int DEFAULT_PAGE_SIZE = 10;

    public <T> Page<T> build() throws Exception {
        Integer pageIndex = this.getPageNum() == null || this.getPageNum() == 0 ? 1 : this.getPageNum();
        Integer pageSize = this.getPageSize() == null || this.getPageSize() == 0 ? 10 : this.getPageSize();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        Page page = new Page((long)pageIndex.intValue(), (long)pageSize.intValue());
        List<OrderItem> orderItems = this.buildOrderItem();
        if (!CollectionUtils.isEmpty(orderItems)) {
            page.addOrder(orderItems);
        }
        return page;
    }

    private List<OrderItem> buildOrderItem() throws Exception {
        ArrayList<OrderItem> list = new ArrayList<OrderItem>();
        if (StringUtils.isEmpty((Object)this.orderByColumn) || StringUtils.isEmpty((Object)this.isAsc)) {
            list.add(OrderItem.desc((String)"id"));
            return list;
        }
        String[] orderByArr = this.orderByColumn.split(",");
        String[] isAscArr = this.isAsc.split(",");
        for (int i = 0; i < orderByArr.length; ++i) {
            String isAscStr;
            String orderByStr = orderByArr[i];
            String string = isAscStr = isAscArr.length == 1 ? isAscArr[0] : isAscArr[i];
            if ("asc".equals(isAscStr)) {
                list.add(OrderItem.asc((String)orderByStr));
                continue;
            }
            if ("desc".equals(isAscStr)) {
                list.add(OrderItem.desc((String)orderByStr));
                continue;
            }
            throw new Exception("\u6392\u5e8f\u53c2\u6570\u9519\u8bef");
        }
        return list;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public String getIsAsc() {
        return this.isAsc;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public void setIsAsc(String isAsc) {
        this.isAsc = isAsc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageQuery)) {
            return false;
        }
        PageQuery other = (PageQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        String this$orderByColumn = this.getOrderByColumn();
        String other$orderByColumn = other.getOrderByColumn();
        if (this$orderByColumn == null ? other$orderByColumn != null : !this$orderByColumn.equals(other$orderByColumn)) {
            return false;
        }
        String this$isAsc = this.getIsAsc();
        String other$isAsc = other.getIsAsc();
        return !(this$isAsc == null ? other$isAsc != null : !this$isAsc.equals(other$isAsc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        String $orderByColumn = this.getOrderByColumn();
        result = result * 59 + ($orderByColumn == null ? 43 : $orderByColumn.hashCode());
        String $isAsc = this.getIsAsc();
        result = result * 59 + ($isAsc == null ? 43 : $isAsc.hashCode());
        return result;
    }

    public String toString() {
        return "PageQuery(pageSize=" + this.getPageSize() + ", pageNum=" + this.getPageNum() + ", orderByColumn=" + this.getOrderByColumn() + ", isAsc=" + this.getIsAsc() + ")";
    }
}

