/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.common.PageQuery;
import tech.qihangec.open.tao.common.PageResult;
import tech.qihangec.open.tao.domain.TaoOrder;
import tech.qihangec.open.tao.domain.TaoOrderItem;
import tech.qihangec.open.tao.mapper.TaoOrderItemMapper;
import tech.qihangec.open.tao.mapper.TaoOrderMapper;
import tech.qihangec.open.tao.service.TaoOrderService;

@Service
public class TaoOrderServiceImpl
extends ServiceImpl<TaoOrderMapper, TaoOrder>
implements TaoOrderService {
    private static Logger log = LoggerFactory.getLogger(TaoOrderServiceImpl.class);
    private final TaoOrderMapper mapper;
    private final TaoOrderItemMapper itemMapper;

    @Override
    public PageResult<TaoOrder> queryPageList(TaoOrder bo, PageQuery pageQuery) throws Exception {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(bo.getShopId() != null, TaoOrder::getShopId, (Object)bo.getShopId())).eq(StringUtils.isNotEmpty(bo.getTid()), TaoOrder::getTid, (Object)bo.getTid());
        Page taoGoodsPage = (Page)this.mapper.selectPage((IPage)pageQuery.build(), (Wrapper)queryWrapper);
        if (taoGoodsPage.getRecords() != null) {
            for (TaoOrder order : taoGoodsPage.getRecords()) {
                order.setItems(this.itemMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TaoOrderItem::getTid, (Object)order.getTid())));
            }
        }
        return PageResult.build(taoGoodsPage);
    }

    @Override
    @Transactional
    public ApiResultVo<Integer> saveOrder(Integer shopId, TaoOrder order) {
        log.info("\u5f00\u59cb\u62a5\u9519\u8ba2\u5355\u6570\u636e");
        if (order == null) {
            return ApiResultVo.error(ApiResultVoEnum.SystemException);
        }
        try {
            List taoOrders = this.mapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TaoOrder::getTid, (Object)order.getTid()));
            if (taoOrders != null && taoOrders.size() > 0) {
                TaoOrder update = new TaoOrder();
                update.setId(((TaoOrder)taoOrders.get(0)).getId());
                update.setSid(order.getSid());
                update.setSellerRate(order.getSellerRate());
                update.setBuyerRate(order.getBuyerRate());
                update.setStatus(order.getStatus());
                update.setModified(order.getModified());
                update.setEndTime(order.getEndTime());
                update.setConsignTime(order.getConsignTime());
                update.setUpdateTime(new Date());
                this.mapper.updateById(update);
                for (TaoOrderItem item : order.getItems()) {
                    List taoOrderItems = this.itemMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TaoOrderItem::getOid, (Object)item.getOid()));
                    if (taoOrderItems != null && taoOrderItems.size() > 0) {
                        TaoOrderItem itemUpdate = new TaoOrderItem();
                        itemUpdate.setId(((TaoOrderItem)taoOrderItems.get(0)).getId());
                        itemUpdate.setRefundId(item.getRefundId());
                        itemUpdate.setRefundStatus(item.getRefundStatus());
                        itemUpdate.setStatus(item.getStatus());
                        itemUpdate.setBuyerRate(item.getBuyerRate());
                        itemUpdate.setSellerRate(item.getSellerRate());
                        itemUpdate.setEndTime(item.getEndTime());
                        itemUpdate.setConsignTime(item.getConsignTime());
                        itemUpdate.setShippingType(item.getShippingType());
                        itemUpdate.setLogisticsCompany(item.getLogisticsCompany());
                        itemUpdate.setInvoiceNo(item.getInvoiceNo());
                        this.itemMapper.updateById(itemUpdate);
                        continue;
                    }
                    this.itemMapper.insert(item);
                }
                log.info("\u4fdd\u5b58\u8ba2\u5355\u6570\u636e\u6210\u529f\uff1a\u4fee\u6539");
                return ApiResultVo.error(ApiResultVoEnum.DataExist, "\u8ba2\u5355\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f");
            }
            order.setShopId(shopId);
            order.setCreateTime(new Date());
            this.mapper.insert(order);
            for (TaoOrderItem item : order.getItems()) {
                this.itemMapper.insert(item);
            }
            log.info("\u4fdd\u5b58\u8ba2\u5355\u6570\u636e\u6210\u529f\uff1a\u65b0\u589e");
            return ApiResultVo.success();
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return ApiResultVo.error(ApiResultVoEnum.SystemException, "\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public TaoOrderServiceImpl(TaoOrderMapper mapper, TaoOrderItemMapper itemMapper) {
        this.mapper = mapper;
        this.itemMapper = itemMapper;
    }
}

