/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.domain.ConfirmConsignGoodsDto;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LogisticsConsignTcConfirmResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogisticsConsignTcConfirmRequest
extends BaseTaobaoRequest<LogisticsConsignTcConfirmResponse> {
    private String appName;
    private String extendFields;
    private String goodsList;
    private String outTradeNo;
    private Long providerId;
    private Long sellerId;
    private Long tradeId;

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setExtendFields(String extendFields) {
        this.extendFields = extendFields;
    }

    public void setExtendFieldsString(String extendFields) {
        this.extendFields = extendFields;
    }

    public String getExtendFields() {
        return this.extendFields;
    }

    public void setGoodsList(String goodsList) {
        this.goodsList = goodsList;
    }

    public void setGoodsList(List<ConfirmConsignGoodsDto> goodsList) {
        this.goodsList = new JSONWriter(false, true).write(goodsList);
    }

    public String getGoodsList() {
        return this.goodsList;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setProviderId(Long providerId) {
        this.providerId = providerId;
    }

    public Long getProviderId() {
        return this.providerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getSellerId() {
        return this.sellerId;
    }

    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    public Long getTradeId() {
        return this.tradeId;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.logistics.consign.tc.confirm";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("app_name", this.appName);
        txtParams.put("extend_fields", this.extendFields);
        txtParams.put("goods_list", this.goodsList);
        txtParams.put("out_trade_no", this.outTradeNo);
        txtParams.put("provider_id", (Object)this.providerId);
        txtParams.put("seller_id", (Object)this.sellerId);
        txtParams.put("trade_id", (Object)this.tradeId);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<LogisticsConsignTcConfirmResponse> getResponseClass() {
        return LogisticsConsignTcConfirmResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.appName, "appName");
        RequestCheckUtils.checkObjectMaxListSize(this.goodsList, 20, "goodsList");
        RequestCheckUtils.checkNotEmpty(this.outTradeNo, "outTradeNo");
        RequestCheckUtils.checkNotEmpty(this.providerId, "providerId");
        RequestCheckUtils.checkNotEmpty(this.sellerId, "sellerId");
        RequestCheckUtils.checkNotEmpty(this.tradeId, "tradeId");
    }
}

