package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtAftersalesRefundRawrefundUploadResponse;

/**
 * TOP API(QimenCloud): wdt.aftersales.refund.rawrefund.upload request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.30
 */
public class WdtAftersalesRefundRawrefundUploadRequest extends BaseTaobaoRequest<WdtAftersalesRefundRawrefundUploadResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 原始退款单列表
	 */
	private String orderList;

	/** 
	* 店铺编号
	 */
	private String shopNo;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setOrderList(String orderList) {
		this.orderList = orderList;
	}

	public void setOrderList(List<Orderlist> orderList) {
		this.orderList = new JSONWriter(false,false,true).write(orderList);
	}

	public String getOrderList() {
		return this.orderList;
	}

	public void setShopNo(String shopNo) {
		this.shopNo = shopNo;
	}

	public String getShopNo() {
		return this.shopNo;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.aftersales.refund.rawrefund.upload";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("order_list", this.orderList);
		txtParams.put("shop_no", this.shopNo);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtAftersalesRefundRawrefundUploadResponse> getResponseClass() {
		return WdtAftersalesRefundRawrefundUploadResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(orderList, 999999, "orderList");
     }
     
	/**
 * 原始退款单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("orderlist")
public static class Orderlist {

	/**
		 * 实际退款金额
		 */
		@ApiField("actual_refund_amount")
		private String actualRefundAmount;
		/**
		 * 客户网名
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 当前状态超时时间
		 */
		@ApiField("current_phase_timeout")
		private String currentPhaseTimeout;
		/**
		 * 平台货品id
		 */
		@ApiField("goods_id")
		private String goodsId;
		/**
		 * 平台货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 是否售后退款单
		 */
		@ApiField("is_aftersale")
		private Boolean isAftersale;
		/**
		 * 物流公司名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 修改掩码,1新订单 2状态变化 4金额变化
		 */
		@ApiField("modify_flag")
		private String modifyFlag;
		/**
		 * 货品数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 买家支付帐号
		 */
		@ApiField("pay_account")
		private String payAccount;
		/**
		 * 支付订单号
		 */
		@ApiField("pay_no")
		private String payNo;
		/**
		 * 单价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 退款原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 申请退款金额
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 原始退款单号
		 */
		@ApiField("refund_no")
		private String refundNo;
		/**
		 * 退款创建时间
		 */
		@ApiField("refund_time")
		private String refundTime;
		/**
		 * 退款版本
		 */
		@ApiField("refund_version")
		private String refundVersion;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 平台规格id
		 */
		@ApiField("spec_id")
		private String specId;
		/**
		 * 规格编号
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 平台状态,1取消退款,2已申请退款,3等待退货,4等待收货,5退款成功
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 标题
		 */
		@ApiField("title")
		private String title;
		/**
		 * 退款货品总价
		 */
		@ApiField("total_amount")
		private String totalAmount;
		/**
		 * 退款单状态,0取消订单1退款(未发货，退款申请)2退货3换货4退款不退货
		 */
		@ApiField("type")
		private Long type;
	

	public String getActualRefundAmount() {
			return this.actualRefundAmount;
		}
		public void setActualRefundAmount(String actualRefundAmount) {
			this.actualRefundAmount = actualRefundAmount;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getCurrentPhaseTimeout() {
			return this.currentPhaseTimeout;
		}
		public void setCurrentPhaseTimeout(String currentPhaseTimeout) {
			this.currentPhaseTimeout = currentPhaseTimeout;
		}
		public String getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(String goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Boolean getIsAftersale() {
			return this.isAftersale;
		}
		public void setIsAftersale(Boolean isAftersale) {
			this.isAftersale = isAftersale;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getModifyFlag() {
			return this.modifyFlag;
		}
		public void setModifyFlag(String modifyFlag) {
			this.modifyFlag = modifyFlag;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public String getPayAccount() {
			return this.payAccount;
		}
		public void setPayAccount(String payAccount) {
			this.payAccount = payAccount;
		}
		public String getPayNo() {
			return this.payNo;
		}
		public void setPayNo(String payNo) {
			this.payNo = payNo;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public String getRefundNo() {
			return this.refundNo;
		}
		public void setRefundNo(String refundNo) {
			this.refundNo = refundNo;
		}
		public String getRefundTime() {
			return this.refundTime;
		}
		public void setRefundTime(String refundTime) {
			this.refundTime = refundTime;
		}
		public String getRefundVersion() {
			return this.refundVersion;
		}
		public void setRefundVersion(String refundVersion) {
			this.refundVersion = refundVersion;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecId() {
			return this.specId;
		}
		public void setSpecId(String specId) {
			this.specId = specId;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}

}



}