package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtGoodsGoodsPushResponse;

/**
 * TOP API(QimenCloud): wdt.goods.goods.push request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.26
 */
public class WdtGoodsGoodsPushRequest extends BaseTaobaoRequest<WdtGoodsGoodsPushResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 货品信息
	 */
	private String goodsInfo;

	/** 
	* 单品信息列表
	 */
	private String specInfoList;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setGoodsInfo(String goodsInfo) {
		this.goodsInfo = goodsInfo;
	}

	public void setGoodsInfo(GoodsInfo goodsInfo) {
		this.goodsInfo = new JSONWriter(false,false,true).write(goodsInfo);
	}

	public String getGoodsInfo() {
		return this.goodsInfo;
	}

	public void setSpecInfoList(String specInfoList) {
		this.specInfoList = specInfoList;
	}

	public void setSpecInfoList(List<SpecInfoList> specInfoList) {
		this.specInfoList = new JSONWriter(false,false,true).write(specInfoList);
	}

	public String getSpecInfoList() {
		return this.specInfoList;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.goods.goods.push";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("goodsInfo", this.goodsInfo);
		txtParams.put("specInfoList", this.specInfoList);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtGoodsGoodsPushResponse> getResponseClass() {
		return WdtGoodsGoodsPushResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(specInfoList, 999999, "specInfoList");
     }
     
	/**
 * 货品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class GoodsInfo {

	/**
		 * 别名
		 */
		@ApiField("alias")
		private String alias;
		/**
		 * 是否自动创建品牌和分类（如果品牌,分类不存在,是否自动创建.不填默认为false）
		 */
		@ApiField("auto_create_bc")
		private Boolean autoCreateBc;
		/**
		 * 辅助单位名称
		 */
		@ApiField("aux_unit_name")
		private String auxUnitName;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 分类名称
		 */
		@ApiField("class_name")
		private String className;
		/**
		 * 货品标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 货品类型（默认0, 1销售商品 2原材料 3包装 4周转材料5虚拟商品6固定资产 0其它）
		 */
		@ApiField("goods_type")
		private String goodsType;
		/**
		 * 产地
		 */
		@ApiField("origin")
		private String origin;
		/**
		 * 拼音
		 */
		@ApiField("pinyin")
		private String pinyin;
		/**
		 * 货品自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 货品自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 货品自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 货品自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 货品自定义属性5
		 */
		@ApiField("prop5")
		private String prop5;
		/**
		 * 货品自定义属性6
		 */
		@ApiField("prop6")
		private String prop6;
		/**
		 * 货品备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 简称
		 */
		@ApiField("short_name")
		private String shortName;
		/**
		 * 基本单位名称
		 */
		@ApiField("unit_name")
		private String unitName;
	

	public String getAlias() {
			return this.alias;
		}
		public void setAlias(String alias) {
			this.alias = alias;
		}
		public Boolean getAutoCreateBc() {
			return this.autoCreateBc;
		}
		public void setAutoCreateBc(Boolean autoCreateBc) {
			this.autoCreateBc = autoCreateBc;
		}
		public String getAuxUnitName() {
			return this.auxUnitName;
		}
		public void setAuxUnitName(String auxUnitName) {
			this.auxUnitName = auxUnitName;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getClassName() {
			return this.className;
		}
		public void setClassName(String className) {
			this.className = className;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getGoodsType() {
			return this.goodsType;
		}
		public void setGoodsType(String goodsType) {
			this.goodsType = goodsType;
		}
		public String getOrigin() {
			return this.origin;
		}
		public void setOrigin(String origin) {
			this.origin = origin;
		}
		public String getPinyin() {
			return this.pinyin;
		}
		public void setPinyin(String pinyin) {
			this.pinyin = pinyin;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getProp5() {
			return this.prop5;
		}
		public void setProp5(String prop5) {
			this.prop5 = prop5;
		}
		public String getProp6() {
			return this.prop6;
		}
		public void setProp6(String prop6) {
			this.prop6 = prop6;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getShortName() {
			return this.shortName;
		}
		public void setShortName(String shortName) {
			this.shortName = shortName;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}

}

	/**
 * 单品信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("specInfoList")
public static class SpecInfoList {

	/**
		 * 辅助单位名称
		 */
		@ApiField("aux_unit_name")
		private String auxUnitName;
		/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 发货积分
		 */
		@ApiField("consign_score")
		private String consignScore;
		/**
		 * 自定义价格1
		 */
		@ApiField("custom_price1")
		private String customPrice1;
		/**
		 * 自定义价格2
		 */
		@ApiField("custom_price2")
		private String customPrice2;
		/**
		 * 货品标签
		 */
		@ApiField("goods_label")
		private String goodsLabel;
		/**
		 * 高度
		 */
		@ApiField("height")
		private String height;
		/**
		 * 图片链接
		 */
		@ApiField("img_url")
		private String imgUrl;
		/**
		 * 质检积分
		 */
		@ApiField("inspect_score")
		private String inspectScore;
		/**
		 * 是否允许低于成本（默认0,0:不允许,1 允许）
		 */
		@ApiField("is_lower_cost")
		private Boolean isLowerCost;
		/**
		 * 是否同一批次出库（默认0,0,不启用同一批次，1,使用同一批次）
		 */
		@ApiField("is_single_batch")
		private Long isSingleBatch;
		/**
		 * 大件类型（默认0, 0非大件1普通大件2独立大件（不可和小件一起发）-1非单发件）
		 */
		@ApiField("large_type")
		private Long largeType;
		/**
		 * 长度
		 */
		@ApiField("length")
		private String length;
		/**
		 * 最低价
		 */
		@ApiField("lowest_price")
		private String lowestPrice;
		/**
		 * 市场价
		 */
		@ApiField("market_price")
		private String marketPrice;
		/**
		 * 会员价
		 */
		@ApiField("member_price")
		private String memberPrice;
		/**
		 * 操作积分
		 */
		@ApiField("operate_score")
		private String operateScore;
		/**
		 * 打包积分
		 */
		@ApiField("pack_score")
		private String packScore;
		/**
		 * 分装积分
		 */
		@ApiField("packing_score")
		private String packingScore;
		/**
		 * 拣货积分
		 */
		@ApiField("pick_score")
		private String pickScore;
		/**
		 * 单品自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 单品自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 单品自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 单品自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 单品自定义属性5
		 */
		@ApiField("prop5")
		private String prop5;
		/**
		 * 单品自定义属性6
		 */
		@ApiField("prop6")
		private String prop6;
		/**
		 * 最佳收货天数
		 */
		@ApiField("receive_days")
		private Long receiveDays;
		/**
		 * 单品备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 零售价
		 */
		@ApiField("retail_price")
		private String retailPrice;
		/**
		 * 销售积分
		 */
		@ApiField("sale_score")
		private String saleScore;
		/**
		 * 最佳销售天数
		 */
		@ApiField("sales_days")
		private Long salesDays;
		/**
		 * 扫描积分
		 */
		@ApiField("scan_score")
		private String scanScore;
		/**
		 * 上架积分
		 */
		@ApiField("shelve_score")
		private String shelveScore;
		/**
		 * sn类型（默认0,0不启用序列号 1强序列号 2弱序列号）
		 */
		@ApiField("sn_type")
		private Long snType;
		/**
		 * 分拣积分
		 */
		@ApiField("sort_score")
		private String sortScore;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 入库积分
		 */
		@ApiField("stockin_score")
		private String stockinScore;
		/**
		 * 补货积分
		 */
		@ApiField("supply_score")
		private String supplyScore;
		/**
		 * 税务编码
		 */
		@ApiField("tax_code")
		private String taxCode;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 基本单位名称
		 */
		@ApiField("unit_name")
		private String unitName;
		/**
		 * 保质期
		 */
		@ApiField("validity_days")
		private Long validityDays;
		/**
		 * 称重积分
		 */
		@ApiField("weigh_score")
		private String weighScore;
		/**
		 * 重量
		 */
		@ApiField("weight")
		private String weight;
		/**
		 * 批发价
		 */
		@ApiField("wholesale_price")
		private String wholesalePrice;
		/**
		 * 宽度
		 */
		@ApiField("width")
		private String width;
		/**
		 * 仓库流程
		 */
		@ApiField("wms_process_mask")
		private Long wmsProcessMask;
	

	public String getAuxUnitName() {
			return this.auxUnitName;
		}
		public void setAuxUnitName(String auxUnitName) {
			this.auxUnitName = auxUnitName;
		}
		public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public String getConsignScore() {
			return this.consignScore;
		}
		public void setConsignScore(String consignScore) {
			this.consignScore = consignScore;
		}
		public String getCustomPrice1() {
			return this.customPrice1;
		}
		public void setCustomPrice1(String customPrice1) {
			this.customPrice1 = customPrice1;
		}
		public String getCustomPrice2() {
			return this.customPrice2;
		}
		public void setCustomPrice2(String customPrice2) {
			this.customPrice2 = customPrice2;
		}
		public String getGoodsLabel() {
			return this.goodsLabel;
		}
		public void setGoodsLabel(String goodsLabel) {
			this.goodsLabel = goodsLabel;
		}
		public String getHeight() {
			return this.height;
		}
		public void setHeight(String height) {
			this.height = height;
		}
		public String getImgUrl() {
			return this.imgUrl;
		}
		public void setImgUrl(String imgUrl) {
			this.imgUrl = imgUrl;
		}
		public String getInspectScore() {
			return this.inspectScore;
		}
		public void setInspectScore(String inspectScore) {
			this.inspectScore = inspectScore;
		}
		public Boolean getIsLowerCost() {
			return this.isLowerCost;
		}
		public void setIsLowerCost(Boolean isLowerCost) {
			this.isLowerCost = isLowerCost;
		}
		public Long getIsSingleBatch() {
			return this.isSingleBatch;
		}
		public void setIsSingleBatch(Long isSingleBatch) {
			this.isSingleBatch = isSingleBatch;
		}
		public Long getLargeType() {
			return this.largeType;
		}
		public void setLargeType(Long largeType) {
			this.largeType = largeType;
		}
		public String getLength() {
			return this.length;
		}
		public void setLength(String length) {
			this.length = length;
		}
		public String getLowestPrice() {
			return this.lowestPrice;
		}
		public void setLowestPrice(String lowestPrice) {
			this.lowestPrice = lowestPrice;
		}
		public String getMarketPrice() {
			return this.marketPrice;
		}
		public void setMarketPrice(String marketPrice) {
			this.marketPrice = marketPrice;
		}
		public String getMemberPrice() {
			return this.memberPrice;
		}
		public void setMemberPrice(String memberPrice) {
			this.memberPrice = memberPrice;
		}
		public String getOperateScore() {
			return this.operateScore;
		}
		public void setOperateScore(String operateScore) {
			this.operateScore = operateScore;
		}
		public String getPackScore() {
			return this.packScore;
		}
		public void setPackScore(String packScore) {
			this.packScore = packScore;
		}
		public String getPackingScore() {
			return this.packingScore;
		}
		public void setPackingScore(String packingScore) {
			this.packingScore = packingScore;
		}
		public String getPickScore() {
			return this.pickScore;
		}
		public void setPickScore(String pickScore) {
			this.pickScore = pickScore;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getProp5() {
			return this.prop5;
		}
		public void setProp5(String prop5) {
			this.prop5 = prop5;
		}
		public String getProp6() {
			return this.prop6;
		}
		public void setProp6(String prop6) {
			this.prop6 = prop6;
		}
		public Long getReceiveDays() {
			return this.receiveDays;
		}
		public void setReceiveDays(Long receiveDays) {
			this.receiveDays = receiveDays;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getRetailPrice() {
			return this.retailPrice;
		}
		public void setRetailPrice(String retailPrice) {
			this.retailPrice = retailPrice;
		}
		public String getSaleScore() {
			return this.saleScore;
		}
		public void setSaleScore(String saleScore) {
			this.saleScore = saleScore;
		}
		public Long getSalesDays() {
			return this.salesDays;
		}
		public void setSalesDays(Long salesDays) {
			this.salesDays = salesDays;
		}
		public String getScanScore() {
			return this.scanScore;
		}
		public void setScanScore(String scanScore) {
			this.scanScore = scanScore;
		}
		public String getShelveScore() {
			return this.shelveScore;
		}
		public void setShelveScore(String shelveScore) {
			this.shelveScore = shelveScore;
		}
		public Long getSnType() {
			return this.snType;
		}
		public void setSnType(Long snType) {
			this.snType = snType;
		}
		public String getSortScore() {
			return this.sortScore;
		}
		public void setSortScore(String sortScore) {
			this.sortScore = sortScore;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getStockinScore() {
			return this.stockinScore;
		}
		public void setStockinScore(String stockinScore) {
			this.stockinScore = stockinScore;
		}
		public String getSupplyScore() {
			return this.supplyScore;
		}
		public void setSupplyScore(String supplyScore) {
			this.supplyScore = supplyScore;
		}
		public String getTaxCode() {
			return this.taxCode;
		}
		public void setTaxCode(String taxCode) {
			this.taxCode = taxCode;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}
		public Long getValidityDays() {
			return this.validityDays;
		}
		public void setValidityDays(Long validityDays) {
			this.validityDays = validityDays;
		}
		public String getWeighScore() {
			return this.weighScore;
		}
		public void setWeighScore(String weighScore) {
			this.weighScore = weighScore;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}
		public String getWholesalePrice() {
			return this.wholesalePrice;
		}
		public void setWholesalePrice(String wholesalePrice) {
			this.wholesalePrice = wholesalePrice;
		}
		public String getWidth() {
			return this.width;
		}
		public void setWidth(String width) {
			this.width = width;
		}
		public Long getWmsProcessMask() {
			return this.wmsProcessMask;
		}
		public void setWmsProcessMask(Long wmsProcessMask) {
			this.wmsProcessMask = wmsProcessMask;
		}

}



}