package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtPurchasePurchaseorderCreateorderResponse;

/**
 * TOP API(QimenCloud): wdt.purchase.purchaseorder.createorder request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.17
 */
public class WdtPurchasePurchaseorderCreateorderRequest extends BaseTaobaoRequest<WdtPurchasePurchaseorderCreateorderResponse> {
     
     

	/** 
	* 时间戳
	 */
	private String datetime;

	/** 
	* 采购单参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.purchase.purchaseorder.createorder";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtPurchasePurchaseorderCreateorderResponse> getResponseClass() {
		return WdtPurchasePurchaseorderCreateorderResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 采购单详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("purchasedetails")
public static class Purchasedetails {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 折扣
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 采购数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 税前单价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 采购单位
		 */
		@ApiField("purchase_unit_name")
		private String purchaseUnitName;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 税后单价
		 */
		@ApiField("tax_price")
		private String taxPrice;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getPurchaseUnitName() {
			return this.purchaseUnitName;
		}
		public void setPurchaseUnitName(String purchaseUnitName) {
			this.purchaseUnitName = purchaseUnitName;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getTaxPrice() {
			return this.taxPrice;
		}
		public void setTaxPrice(String taxPrice) {
			this.taxPrice = taxPrice;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}

}

	/**
 * 采购单参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 引用的采购申请单编号,使用英文逗号隔开
		 */
		@ApiField("apply_nos")
		private String applyNos;
		/**
		 * 联系人
		 */
		@ApiField("contact")
		private String contact;
		/**
		 * 不传或为空,则为当前时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 预计到货时间
		 */
		@ApiField("expect_time")
		private String expectTime;
		/**
		 * 预计入库仓库编号
		 */
		@ApiField("expect_warehouse_no")
		private String expectWarehouseNo;
		/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 是否要审核,不传默认为false
		 */
		@ApiField("is_check")
		private Boolean isCheck;
		/**
		 * 物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 系统内维护的物流公司编号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 其他费用
		 */
		@ApiField("other_fee")
		private String otherFee;
		/**
		 * 付款方式，1:现付 2:到付
		 */
		@ApiField("pay_type")
		private Long payType;
		/**
		 * 邮费
		 */
		@ApiField("post_fee")
		private String postFee;
		/**
		 * 运费支付方式，0 无 1 现付 2 到付 3 包邮
		 */
		@ApiField("postfee_pay_type")
		private Long postfeePayType;
		/**
		 * 采购单自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 采购单自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 采购单详情
		 */
		@ApiListField("purchase_details")
		@ApiField("purchasedetails")
		private List<Purchasedetails> purchaseDetails;
		/**
		 * 采购单编号
		 */
		@ApiField("purchase_no")
		private String purchaseNo;
		/**
		 * 采购员
		 */
		@ApiField("purchaser_name")
		private String purchaserName;
		/**
		 * 收货地址
		 */
		@ApiField("receive_address")
		private String receiveAddress;
		/**
		 * 收货仓编号
		 */
		@ApiField("receive_warehouse_nos")
		private String receiveWarehouseNos;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 电话
		 */
		@ApiField("telno")
		private String telno;
	

	public String getApplyNos() {
			return this.applyNos;
		}
		public void setApplyNos(String applyNos) {
			this.applyNos = applyNos;
		}
		public String getContact() {
			return this.contact;
		}
		public void setContact(String contact) {
			this.contact = contact;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getExpectTime() {
			return this.expectTime;
		}
		public void setExpectTime(String expectTime) {
			this.expectTime = expectTime;
		}
		public String getExpectWarehouseNo() {
			return this.expectWarehouseNo;
		}
		public void setExpectWarehouseNo(String expectWarehouseNo) {
			this.expectWarehouseNo = expectWarehouseNo;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public Boolean getIsCheck() {
			return this.isCheck;
		}
		public void setIsCheck(Boolean isCheck) {
			this.isCheck = isCheck;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getOtherFee() {
			return this.otherFee;
		}
		public void setOtherFee(String otherFee) {
			this.otherFee = otherFee;
		}
		public Long getPayType() {
			return this.payType;
		}
		public void setPayType(Long payType) {
			this.payType = payType;
		}
		public String getPostFee() {
			return this.postFee;
		}
		public void setPostFee(String postFee) {
			this.postFee = postFee;
		}
		public Long getPostfeePayType() {
			return this.postfeePayType;
		}
		public void setPostfeePayType(Long postfeePayType) {
			this.postfeePayType = postfeePayType;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public List<Purchasedetails> getPurchaseDetails() {
			return this.purchaseDetails;
		}
		public void setPurchaseDetails(List<Purchasedetails> purchaseDetails) {
			this.purchaseDetails = purchaseDetails;
		}
		public String getPurchaseNo() {
			return this.purchaseNo;
		}
		public void setPurchaseNo(String purchaseNo) {
			this.purchaseNo = purchaseNo;
		}
		public String getPurchaserName() {
			return this.purchaserName;
		}
		public void setPurchaserName(String purchaserName) {
			this.purchaserName = purchaserName;
		}
		public String getReceiveAddress() {
			return this.receiveAddress;
		}
		public void setReceiveAddress(String receiveAddress) {
			this.receiveAddress = receiveAddress;
		}
		public String getReceiveWarehouseNos() {
			return this.receiveWarehouseNos;
		}
		public void setReceiveWarehouseNos(String receiveWarehouseNos) {
			this.receiveWarehouseNos = receiveWarehouseNos;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getTelno() {
			return this.telno;
		}
		public void setTelno(String telno) {
			this.telno = telno;
		}

}



}