package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtSalesLogisticssyncUpdateResponse;

/**
 * TOP API(QimenCloud): wdt.sales.logisticssync.update request
 * 
 * @author top auto create
 * @since 1.0, 2020.08.28
 */
public class WdtSalesLogisticssyncUpdateRequest extends BaseTaobaoRequest<WdtSalesLogisticssyncUpdateResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 同步结果列表
	 */
	private String syncList;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setSyncList(String syncList) {
		this.syncList = syncList;
	}

	public void setSyncList(List<SyncList> syncList) {
		this.syncList = new JSONWriter(false,false,true).write(syncList);
	}

	public String getSyncList() {
		return this.syncList;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.sales.logisticssync.update";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("syncList", this.syncList);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtSalesLogisticssyncUpdateResponse> getResponseClass() {
		return WdtSalesLogisticssyncUpdateResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(syncList, 999999, "syncList");
     }
     
	/**
 * 同步结果列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("syncList")
public static class SyncList {

	/**
		 * 错误信息 失败的错误信息，若成功传“”
		 */
		@ApiField("error_msg")
		private String errorMsg;
		/**
		 * 同步结果 0: 同步成功、-100: 还需同步，2:同步失败
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 物流同步id 在物流同步接口获取到的物流同步id
		 */
		@ApiField("sync_id")
		private Long syncId;
	

	public String getErrorMsg() {
			return this.errorMsg;
		}
		public void setErrorMsg(String errorMsg) {
			this.errorMsg = errorMsg;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getSyncId() {
			return this.syncId;
		}
		public void setSyncId(Long syncId) {
			this.syncId = syncId;
		}

}



}