package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtSalesPaymentQuerywithdetailResponse;

/**
 * TOP API(QimenCloud): wdt.sales.payment.querywithdetail request
 * 
 * @author top auto create
 * @since 1.0, 2023.02.13
 */
public class WdtSalesPaymentQuerywithdetailRequest extends BaseTaobaoRequest<WdtSalesPaymentQuerywithdetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页信息
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* wdt_sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.sales.payment.querywithdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtSalesPaymentQuerywithdetailResponse> getResponseClass() {
		return WdtSalesPaymentQuerywithdetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 方向
		 */
		@ApiField("is_refund")
		private Long isRefund;
		/**
		 * 收付单号
		 */
		@ApiField("payment_no")
		private String paymentNo;
		/**
		 * 业务单号
		 */
		@ApiField("sales_order_no")
		private String salesOrderNo;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_nos")
		private String shopNos;
		/**
		 * 开始时间
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 时间类型
		 */
		@ApiField("time_type")
		private Long timeType;
	

	public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public Long getIsRefund() {
			return this.isRefund;
		}
		public void setIsRefund(Long isRefund) {
			this.isRefund = isRefund;
		}
		public String getPaymentNo() {
			return this.paymentNo;
		}
		public void setPaymentNo(String paymentNo) {
			this.paymentNo = paymentNo;
		}
		public String getSalesOrderNo() {
			return this.salesOrderNo;
		}
		public void setSalesOrderNo(String salesOrderNo) {
			this.salesOrderNo = salesOrderNo;
		}
		public String getShopNos() {
			return this.shopNos;
		}
		public void setShopNos(String shopNos) {
			this.shopNos = shopNos;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getTimeType() {
			return this.timeType;
		}
		public void setTimeType(Long timeType) {
			this.timeType = timeType;
		}

}

	/**
 * 分页信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}