package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtSalesRawtradePushselfResponse;

/**
 * TOP API(QimenCloud): wdt.sales.rawtrade.pushself request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.24
 */
public class WdtSalesRawtradePushselfRequest extends BaseTaobaoRequest<WdtSalesRawtradePushselfResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 优惠信息（不需要优惠明细可不传,优惠明细显示在订单管理界面的优惠明细Tab页）
	 */
	private String discountList;

	/** 
	* 原始单信息
	 */
	private String rawTradeList;

	/** 
	* 原始子单信息
	 */
	private String rawTradeOrderList;

	/** 
	* 店铺编号
	 */
	private String shopNo;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setDiscountList(String discountList) {
		this.discountList = discountList;
	}

	public void setDiscountList(List<DiscountList> discountList) {
		this.discountList = new JSONWriter(false,false,true).write(discountList);
	}

	public String getDiscountList() {
		return this.discountList;
	}

	public void setRawTradeList(String rawTradeList) {
		this.rawTradeList = rawTradeList;
	}

	public void setRawTradeList(List<RawTradeList> rawTradeList) {
		this.rawTradeList = new JSONWriter(false,false,true).write(rawTradeList);
	}

	public String getRawTradeList() {
		return this.rawTradeList;
	}

	public void setRawTradeOrderList(String rawTradeOrderList) {
		this.rawTradeOrderList = rawTradeOrderList;
	}

	public void setRawTradeOrderList(List<RawTradeOrderList> rawTradeOrderList) {
		this.rawTradeOrderList = new JSONWriter(false,false,true).write(rawTradeOrderList);
	}

	public String getRawTradeOrderList() {
		return this.rawTradeOrderList;
	}

	public void setShopNo(String shopNo) {
		this.shopNo = shopNo;
	}

	public String getShopNo() {
		return this.shopNo;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.sales.rawtrade.pushself";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("discountList", this.discountList);
		txtParams.put("rawTradeList", this.rawTradeList);
		txtParams.put("rawTradeOrderList", this.rawTradeOrderList);
		txtParams.put("shopNo", this.shopNo);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtSalesRawtradePushselfResponse> getResponseClass() {
		return WdtSalesRawtradePushselfResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(discountList, 999999, "discountList");
		RequestCheckUtils.checkObjectMaxListSize(rawTradeList, 999999, "rawTradeList");
		RequestCheckUtils.checkObjectMaxListSize(rawTradeOrderList, 999999, "rawTradeOrderList");
     }
     
	/**
 * 原始单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("rawTradeList")
public static class RawTradeList {

	/**
		 * 买家地区
		 */
		@ApiField("buyer_area")
		private String buyerArea;
		/**
		 * 买家邮箱
		 */
		@ApiField("buyer_email")
		private String buyerEmail;
		/**
		 * 买家备注，若无则传''
		 */
		@ApiField("buyer_message")
		private String buyerMessage;
		/**
		 * 买家账号
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 货到付款金额
		 */
		@ApiField("cod_amount")
		private String codAmount;
		/**
		 * 淘宝新增,物流到货时效，单位天
		 */
		@ApiField("consign_interval")
		private Long consignInterval;
		/**
		 * 系统物流编号
		 */
		@ApiField("cust_data")
		private String custData;
		/**
		 * 发货条件,1款到发货 2货到付款(包含部分货到付款) 3分期付款
		 */
		@ApiField("delivery_term")
		private Long deliveryTerm;
		/**
		 * 优惠金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 交易结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 货品总数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 发票内容
		 */
		@ApiField("invoice_content")
		private String invoiceContent;
		/**
		 * 发票抬头
		 */
		@ApiField("invoice_title")
		private String invoiceTitle;
		/**
		 * 发票类别，0 不需要，1普通发票，2增值税发票
		 */
		@ApiField("invoice_type")
		private Long invoiceType;
		/**
		 * 是否是自流转
		 */
		@ApiField("is_auto_wms")
		private Boolean isAutoWms;
		/**
		 * 物流类别
		 */
		@ApiField("logistics_type")
		private Long logisticsType;
		/**
		 * 子订单个数，原始单包含的子订单数
		 */
		@ApiField("order_count")
		private Long orderCount;
		/**
		 * 其他费用
		 */
		@ApiField("other_amount")
		private String otherAmount;
		/**
		 * 买家支付宝帐号
		 */
		@ApiField("pay_account")
		private String payAccount;
		/**
		 * 平台支付订单ID
		 */
		@ApiField("pay_id")
		private String payId;
		/**
		 * 支付方式，1在线转帐 2现金，3银行转账，4邮局汇款 5预付款 6刷卡
		 */
		@ApiField("pay_method")
		private Long payMethod;
		/**
		 * 退款状态，0未付款1部分付款2已付款
		 */
		@ApiField("pay_status")
		private Long payStatus;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private String payTime;
		/**
		 * 平台费用
		 */
		@ApiField("platform_cost")
		private String platformCost;
		/**
		 * 邮费
		 */
		@ApiField("post_amount")
		private String postAmount;
		/**
		 * 处理状态，若为线下门店订单则统一为10。 10: 待递交，20: 已递交，30: 部分发货， 40: 已发货， 60: 已完成， 70: 已取消
		 */
		@ApiField("process_status")
		private Long processStatus;
		/**
		 * 应收金额
		 */
		@ApiField("receivable")
		private String receivable;
		/**
		 * 已从平台收款的金额
		 */
		@ApiField("received")
		private String received;
		/**
		 * 地址
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 省市区
		 */
		@ApiField("receiver_area")
		private String receiverArea;
		/**
		 * 收件人电话，没有传空
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 收件人电话
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 收件人邮编
		 */
		@ApiField("receiver_zip")
		private String receiverZip;
		/**
		 * 退款状态（0无退款 1申请退款 2部分退款 3全部退款）
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 客服备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 客服备注标记，标旗, 无则填0
		 */
		@ApiField("remark_flag")
		private Long remarkFlag;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 买家要求的送货日期
		 */
		@ApiField("to_deliver_time")
		private String toDeliverTime;
		/**
		 * 平台状态，10未确认 20待尾款 30待发货 40部分发货 50已发货 60已签收 70已完成 80已退款 90已关闭(付款前取消)
		 */
		@ApiField("trade_status")
		private Long tradeStatus;
		/**
		 * 下单时间
		 */
		@ApiField("trade_time")
		private String tradeTime;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getBuyerArea() {
			return this.buyerArea;
		}
		public void setBuyerArea(String buyerArea) {
			this.buyerArea = buyerArea;
		}
		public String getBuyerEmail() {
			return this.buyerEmail;
		}
		public void setBuyerEmail(String buyerEmail) {
			this.buyerEmail = buyerEmail;
		}
		public String getBuyerMessage() {
			return this.buyerMessage;
		}
		public void setBuyerMessage(String buyerMessage) {
			this.buyerMessage = buyerMessage;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getCodAmount() {
			return this.codAmount;
		}
		public void setCodAmount(String codAmount) {
			this.codAmount = codAmount;
		}
		public Long getConsignInterval() {
			return this.consignInterval;
		}
		public void setConsignInterval(Long consignInterval) {
			this.consignInterval = consignInterval;
		}
		public String getCustData() {
			return this.custData;
		}
		public void setCustData(String custData) {
			this.custData = custData;
		}
		public Long getDeliveryTerm() {
			return this.deliveryTerm;
		}
		public void setDeliveryTerm(Long deliveryTerm) {
			this.deliveryTerm = deliveryTerm;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getInvoiceContent() {
			return this.invoiceContent;
		}
		public void setInvoiceContent(String invoiceContent) {
			this.invoiceContent = invoiceContent;
		}
		public String getInvoiceTitle() {
			return this.invoiceTitle;
		}
		public void setInvoiceTitle(String invoiceTitle) {
			this.invoiceTitle = invoiceTitle;
		}
		public Long getInvoiceType() {
			return this.invoiceType;
		}
		public void setInvoiceType(Long invoiceType) {
			this.invoiceType = invoiceType;
		}
		public Boolean getIsAutoWms() {
			return this.isAutoWms;
		}
		public void setIsAutoWms(Boolean isAutoWms) {
			this.isAutoWms = isAutoWms;
		}
		public Long getLogisticsType() {
			return this.logisticsType;
		}
		public void setLogisticsType(Long logisticsType) {
			this.logisticsType = logisticsType;
		}
		public Long getOrderCount() {
			return this.orderCount;
		}
		public void setOrderCount(Long orderCount) {
			this.orderCount = orderCount;
		}
		public String getOtherAmount() {
			return this.otherAmount;
		}
		public void setOtherAmount(String otherAmount) {
			this.otherAmount = otherAmount;
		}
		public String getPayAccount() {
			return this.payAccount;
		}
		public void setPayAccount(String payAccount) {
			this.payAccount = payAccount;
		}
		public String getPayId() {
			return this.payId;
		}
		public void setPayId(String payId) {
			this.payId = payId;
		}
		public Long getPayMethod() {
			return this.payMethod;
		}
		public void setPayMethod(Long payMethod) {
			this.payMethod = payMethod;
		}
		public Long getPayStatus() {
			return this.payStatus;
		}
		public void setPayStatus(Long payStatus) {
			this.payStatus = payStatus;
		}
		public String getPayTime() {
			return this.payTime;
		}
		public void setPayTime(String payTime) {
			this.payTime = payTime;
		}
		public String getPlatformCost() {
			return this.platformCost;
		}
		public void setPlatformCost(String platformCost) {
			this.platformCost = platformCost;
		}
		public String getPostAmount() {
			return this.postAmount;
		}
		public void setPostAmount(String postAmount) {
			this.postAmount = postAmount;
		}
		public Long getProcessStatus() {
			return this.processStatus;
		}
		public void setProcessStatus(Long processStatus) {
			this.processStatus = processStatus;
		}
		public String getReceivable() {
			return this.receivable;
		}
		public void setReceivable(String receivable) {
			this.receivable = receivable;
		}
		public String getReceived() {
			return this.received;
		}
		public void setReceived(String received) {
			this.received = received;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public String getReceiverArea() {
			return this.receiverArea;
		}
		public void setReceiverArea(String receiverArea) {
			this.receiverArea = receiverArea;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public String getReceiverZip() {
			return this.receiverZip;
		}
		public void setReceiverZip(String receiverZip) {
			this.receiverZip = receiverZip;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getRemarkFlag() {
			return this.remarkFlag;
		}
		public void setRemarkFlag(Long remarkFlag) {
			this.remarkFlag = remarkFlag;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getToDeliverTime() {
			return this.toDeliverTime;
		}
		public void setToDeliverTime(String toDeliverTime) {
			this.toDeliverTime = toDeliverTime;
		}
		public Long getTradeStatus() {
			return this.tradeStatus;
		}
		public void setTradeStatus(Long tradeStatus) {
			this.tradeStatus = tradeStatus;
		}
		public String getTradeTime() {
			return this.tradeTime;
		}
		public void setTradeTime(String tradeTime) {
			this.tradeTime = tradeTime;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 优惠信息（不需要优惠明细可不传,优惠明细显示在订单管理界面的优惠明细Tab页）
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("discountList")
public static class DiscountList {

	/**
		 * 优惠金额
		 */
		@ApiField("amount")
		private String amount;
		/**
		 * 优惠详情
		 */
		@ApiField("detail")
		private String detail;
		/**
		 * 是否优惠券
		 */
		@ApiField("is_bonus")
		private String isBonus;
		/**
		 * 优惠名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 唯一编号
		 */
		@ApiField("sn")
		private String sn;
		/**
		 * 原始订单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 类型
		 */
		@ApiField("type")
		private String type;
	

	public String getAmount() {
			return this.amount;
		}
		public void setAmount(String amount) {
			this.amount = amount;
		}
		public String getDetail() {
			return this.detail;
		}
		public void setDetail(String detail) {
			this.detail = detail;
		}
		public String getIsBonus() {
			return this.isBonus;
		}
		public void setIsBonus(String isBonus) {
			this.isBonus = isBonus;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public String getSn() {
			return this.sn;
		}
		public void setSn(String sn) {
			this.sn = sn;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 原始子单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("rawTradeOrderList")
public static class RawTradeOrderList {

	/**
		 * 手工调整的优惠金额
		 */
		@ApiField("adjust_amount")
		private String adjustAmount;
		/**
		 * 平台类目
		 */
		@ApiField("cid")
		private String cid;
		/**
		 * 平台折扣, 不包含手工调整和分摊优惠
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 平台货品ID
		 */
		@ApiField("goods_id")
		private String goodsId;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * json串，若无可传空
		 */
		@ApiField("json")
		private String json;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 子单类型,0正常货品 1虚拟货品 2服务
		 */
		@ApiField("order_type")
		private Long orderType;
		/**
		 * 单价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 退款金额
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 退款状态，0无退款1取消退款,2已申请退款,3等待退货,4等待收货,5退款成功,6未付款关闭
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 分摊折扣
		 */
		@ApiField("share_discount")
		private String shareDiscount;
		/**
		 * 平台规格ID
		 */
		@ApiField("spec_id")
		private String specId;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 规格编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 平台状态，10未确认 20待尾款 30待发货 40部分发货 50已发货 60已签收 70已完成 80已退款 90已关闭
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 原始订单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 总价格
		 */
		@ApiField("total_amount")
		private String totalAmount;
	

	public String getAdjustAmount() {
			return this.adjustAmount;
		}
		public void setAdjustAmount(String adjustAmount) {
			this.adjustAmount = adjustAmount;
		}
		public String getCid() {
			return this.cid;
		}
		public void setCid(String cid) {
			this.cid = cid;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(String goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getJson() {
			return this.json;
		}
		public void setJson(String json) {
			this.json = json;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public Long getOrderType() {
			return this.orderType;
		}
		public void setOrderType(Long orderType) {
			this.orderType = orderType;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getShareDiscount() {
			return this.shareDiscount;
		}
		public void setShareDiscount(String shareDiscount) {
			this.shareDiscount = shareDiscount;
		}
		public String getSpecId() {
			return this.specId;
		}
		public void setSpecId(String specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}

}



}