package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinOtherCreateotherstockinorderResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.other.createotherstockinorder request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.16
 */
public class WdtWmsStockinOtherCreateotherstockinorderRequest extends BaseTaobaoRequest<WdtWmsStockinOtherCreateotherstockinorderResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 入库单单据信息
	 */
	private String stockinOrder;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setStockinOrder(String stockinOrder) {
		this.stockinOrder = stockinOrder;
	}

	public void setStockinOrder(StockinOrder stockinOrder) {
		this.stockinOrder = new JSONWriter(false,false,true).write(stockinOrder);
	}

	public String getStockinOrder() {
		return this.stockinOrder;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.other.createotherstockinorder";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("stockin_order", this.stockinOrder);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinOtherCreateotherstockinorderResponse> getResponseClass() {
		return WdtWmsStockinOtherCreateotherstockinorderResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 货品详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("goodsList")
public static class GoodsList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 入库数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 生产日期
		 */
		@ApiField("production_date")
		private String productionDate;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getProductionDate() {
			return this.productionDate;
		}
		public void setProductionDate(String productionDate) {
			this.productionDate = productionDate;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}

}

	/**
 * 入库单单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class StockinOrder {

	/**
		 * 货品详情
		 */
		@ApiListField("goods_list")
		@ApiField("goodsList")
		private List<GoodsList> goodsList;
		/**
		 * 是否审核（True审核，默认false）
		 */
		@ApiField("is_check")
		private Boolean isCheck;
		/**
		 * 物流编码
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 外部单号
		 */
		@ApiField("outer_no")
		private String outerNo;
		/**
		 * 入库原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 仓库编码
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public List<GoodsList> getGoodsList() {
			return this.goodsList;
		}
		public void setGoodsList(List<GoodsList> goodsList) {
			this.goodsList = goodsList;
		}
		public Boolean getIsCheck() {
			return this.isCheck;
		}
		public void setIsCheck(Boolean isCheck) {
			this.isCheck = isCheck;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getOuterNo() {
			return this.outerNo;
		}
		public void setOuterNo(String outerNo) {
			this.outerNo = outerNo;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}



}