package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinOtherQuerywithdetailResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.other.querywithdetail request
 * 
 * @author top auto create
 * @since 1.0, 2023.08.22
 */
public class WdtWmsStockinOtherQuerywithdetailRequest extends BaseTaobaoRequest<WdtWmsStockinOtherQuerywithdetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页参数
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.other.querywithdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinOtherQuerywithdetailResponse> getResponseClass() {
		return WdtWmsStockinOtherQuerywithdetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 其它入库业务单号
		 */
		@ApiField("other_stockin_no")
		private String otherStockinNo;
		/**
		 * 入库原因
		 */
		@ApiField("reason_name")
		private String reasonName;
		/**
		 * 起始时间，若无入库单号或源单号，则为必填。
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 入库单状态，英文逗号拼接的状态值:  10=已取消，20=编辑中，30=待审核，37=待质检， 40=质检确认， 60=待结算，70=暂估结算，80=已完成
		 */
		@ApiField("status")
		private String status;
		/**
		 * 入库单号
		 */
		@ApiField("stockin_no")
		private String stockinNo;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getOtherStockinNo() {
			return this.otherStockinNo;
		}
		public void setOtherStockinNo(String otherStockinNo) {
			this.otherStockinNo = otherStockinNo;
		}
		public String getReasonName() {
			return this.reasonName;
		}
		public void setReasonName(String reasonName) {
			this.reasonName = reasonName;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStockinNo() {
			return this.stockinNo;
		}
		public void setStockinNo(String stockinNo) {
			this.stockinNo = stockinNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 分页参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}