package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinPrestockinSearchResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.prestockin.search request
 * 
 * @author top auto create
 * @since 1.0, 2023.08.22
 */
public class WdtWmsStockinPrestockinSearchRequest extends BaseTaobaoRequest<WdtWmsStockinPrestockinSearchResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockin.prestockin.search";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockinPrestockinSearchResponse> getResponseClass() {
		return WdtWmsStockinPrestockinSearchResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 客户网名
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 创建起始时间
		 */
		@ApiField("ct_from")
		private String ctFrom;
		/**
		 * 创建结束时间
		 */
		@ApiField("ct_to")
		private String ctTo;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 最后修改起始时间
		 */
		@ApiField("mt_from")
		private String mtFrom;
		/**
		 * 最后修改结束时间
		 */
		@ApiField("mt_to")
		private String mtTo;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 退货人手机
		 */
		@ApiField("sender_mobile")
		private String senderMobile;
		/**
		 * 退货人姓名
		 */
		@ApiField("sender_name")
		private String senderName;
		/**
		 * 货品简称
		 */
		@ApiField("short_name")
		private String shortName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 状态 10:已取消;20编辑中;30:待审核;80:已完成
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 入库单号
		 */
		@ApiField("stockin_no")
		private String stockinNo;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getCtFrom() {
			return this.ctFrom;
		}
		public void setCtFrom(String ctFrom) {
			this.ctFrom = ctFrom;
		}
		public String getCtTo() {
			return this.ctTo;
		}
		public void setCtTo(String ctTo) {
			this.ctTo = ctTo;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getMtFrom() {
			return this.mtFrom;
		}
		public void setMtFrom(String mtFrom) {
			this.mtFrom = mtFrom;
		}
		public String getMtTo() {
			return this.mtTo;
		}
		public void setMtTo(String mtTo) {
			this.mtTo = mtTo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSenderMobile() {
			return this.senderMobile;
		}
		public void setSenderMobile(String senderMobile) {
			this.senderMobile = senderMobile;
		}
		public String getSenderName() {
			return this.senderName;
		}
		public void setSenderName(String senderName) {
			this.senderName = senderName;
		}
		public String getShortName() {
			return this.shortName;
		}
		public void setShortName(String shortName) {
			this.shortName = shortName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getStockinNo() {
			return this.stockinNo;
		}
		public void setStockinNo(String stockinNo) {
			this.stockinNo = stockinNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 分页
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号 从0开始
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}