package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockoutTransferCreateorderResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockout.transfer.createorder request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.30
 */
public class WdtWmsStockoutTransferCreateorderRequest extends BaseTaobaoRequest<WdtWmsStockoutTransferCreateorderResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 调拨出库单明细信息
	 */
	private String detailList;

	/** 
	* 是否审核
	 */
	private Boolean isCheck;

	/** 
	* 调拨出库单单据信息
	 */
	private String orderInfo;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setDetailList(String detailList) {
		this.detailList = detailList;
	}

	public void setDetailList(List<DetailList> detailList) {
		this.detailList = new JSONWriter(false,false,true).write(detailList);
	}

	public String getDetailList() {
		return this.detailList;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public Boolean getIsCheck() {
		return this.isCheck;
	}

	public void setOrderInfo(String orderInfo) {
		this.orderInfo = orderInfo;
	}

	public void setOrderInfo(OrderInfo orderInfo) {
		this.orderInfo = new JSONWriter(false,false,true).write(orderInfo);
	}

	public String getOrderInfo() {
		return this.orderInfo;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockout.transfer.createorder";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("detailList", this.detailList);
		txtParams.put("isCheck", this.isCheck);
		txtParams.put("orderInfo", this.orderInfo);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockoutTransferCreateorderResponse> getResponseClass() {
		return WdtWmsStockoutTransferCreateorderResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(detailList, 999999, "detailList");
     }
     
	/**
 * 调拨出库单单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class OrderInfo {

	/**
		 * 物流编码
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 源调拨单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 调出仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 调拨出库单明细信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("detailList")
public static class DetailList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 调拨数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 调出货位 调出货位，不传取系统配置的默认货位
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 单品信息
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 基本单位
		 */
		@ApiField("unit_name")
		private String unitName;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}

}



}