package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.goods.suite.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtGoodsSuiteSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6453719435552136944L;

	/** 
	 * 货品数据 货品相关数据
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息 无错误信息不返回
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码返回0为正常
	 */
	@ApiField("status")
	private String status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatus( ) {
		return this.status;
	}
	
	/**
 * 组合装明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailList {

	/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * deleted
		 */
		@ApiField("deleted")
		private Long deleted;
		/**
		 * 固定金额
		 */
		@ApiField("fixed_price")
		private String fixedPrice;
		/**
		 * 货品主键
		 */
		@ApiField("goods_id")
		private Long goodsId;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 是否固定价格
		 */
		@ApiField("is_fixed_price")
		private Boolean isFixedPrice;
		/**
		 * 组合装明细修改时间 不是单品修改时间，是组合装明细修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 占组合装总价格百分比
		 */
		@ApiField("ratio")
		private String ratio;
		/**
		 * 明细主键id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 单品主键
		 */
		@ApiField("spec_id")
		private Long specId;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 组合装主键
		 */
		@ApiField("suite_id")
		private Long suiteId;
		/**
		 * unit
		 */
		@ApiField("unit")
		private Long unit;
	

	public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public Long getDeleted() {
			return this.deleted;
		}
		public void setDeleted(Long deleted) {
			this.deleted = deleted;
		}
		public String getFixedPrice() {
			return this.fixedPrice;
		}
		public void setFixedPrice(String fixedPrice) {
			this.fixedPrice = fixedPrice;
		}
		public Long getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(Long goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Boolean getIsFixedPrice() {
			return this.isFixedPrice;
		}
		public void setIsFixedPrice(Boolean isFixedPrice) {
			this.isFixedPrice = isFixedPrice;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getRatio() {
			return this.ratio;
		}
		public void setRatio(String ratio) {
			this.ratio = ratio;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public Long getSpecId() {
			return this.specId;
		}
		public void setSpecId(Long specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getSuiteId() {
			return this.suiteId;
		}
		public void setSuiteId(Long suiteId) {
			this.suiteId = suiteId;
		}
		public Long getUnit() {
			return this.unit;
		}
		public void setUnit(Long unit) {
			this.unit = unit;
		}

}

	/**
 * 货品数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class SuiteList {

	/**
		 * 辅助单位
		 */
		@ApiField("aux_unit_name")
		private String auxUnitName;
		/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 条码个数
		 */
		@ApiField("barcode_count")
		private Long barcodeCount;
		/**
		 * 品牌id
		 */
		@ApiField("brand_id")
		private Long brandId;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 分类名称
		 */
		@ApiField("class_name")
		private String className;
		/**
		 * 是否已删除
		 */
		@ApiField("deleted")
		private Long deleted;
		/**
		 * 组合装明细
		 */
		@ApiListField("detail_list")
		@ApiField("detailList")
		private List<DetailList> detailList;
		/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 货品标签
		 */
		@ApiField("goods_lable")
		private String goodsLable;
		/**
		 * 市场价
		 */
		@ApiField("market_price")
		private String marketPrice;
		/**
		 * 会员价
		 */
		@ApiField("member_price")
		private String memberPrice;
		/**
		 * 打印方式
		 */
		@ApiField("print_suite_mode")
		private Long printSuiteMode;
		/**
		 * 自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 零售价
		 */
		@ApiField("retail_price")
		private String retailPrice;
		/**
		 * 简称
		 */
		@ApiField("short_name")
		private String shortName;
		/**
		 * 组合装创建时间
		 */
		@ApiField("suite_created")
		private String suiteCreated;
		/**
		 * 组合装主键
		 */
		@ApiField("suite_id")
		private Long suiteId;
		/**
		 * 组合装修改时间
		 */
		@ApiField("suite_modified")
		private String suiteModified;
		/**
		 * 组合装名称
		 */
		@ApiField("suite_name")
		private String suiteName;
		/**
		 * 组合装商家编码
		 */
		@ApiField("suite_no")
		private String suiteNo;
		/**
		 * 基本单位
		 */
		@ApiField("unit_name")
		private String unitName;
		/**
		 * 重量
		 */
		@ApiField("weight")
		private String weight;
		/**
		 * 批发价
		 */
		@ApiField("wholesale_price")
		private String wholesalePrice;
	

	public String getAuxUnitName() {
			return this.auxUnitName;
		}
		public void setAuxUnitName(String auxUnitName) {
			this.auxUnitName = auxUnitName;
		}
		public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public Long getBarcodeCount() {
			return this.barcodeCount;
		}
		public void setBarcodeCount(Long barcodeCount) {
			this.barcodeCount = barcodeCount;
		}
		public Long getBrandId() {
			return this.brandId;
		}
		public void setBrandId(Long brandId) {
			this.brandId = brandId;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getClassName() {
			return this.className;
		}
		public void setClassName(String className) {
			this.className = className;
		}
		public Long getDeleted() {
			return this.deleted;
		}
		public void setDeleted(Long deleted) {
			this.deleted = deleted;
		}
		public List<DetailList> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<DetailList> detailList) {
			this.detailList = detailList;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getGoodsLable() {
			return this.goodsLable;
		}
		public void setGoodsLable(String goodsLable) {
			this.goodsLable = goodsLable;
		}
		public String getMarketPrice() {
			return this.marketPrice;
		}
		public void setMarketPrice(String marketPrice) {
			this.marketPrice = marketPrice;
		}
		public String getMemberPrice() {
			return this.memberPrice;
		}
		public void setMemberPrice(String memberPrice) {
			this.memberPrice = memberPrice;
		}
		public Long getPrintSuiteMode() {
			return this.printSuiteMode;
		}
		public void setPrintSuiteMode(Long printSuiteMode) {
			this.printSuiteMode = printSuiteMode;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getRetailPrice() {
			return this.retailPrice;
		}
		public void setRetailPrice(String retailPrice) {
			this.retailPrice = retailPrice;
		}
		public String getShortName() {
			return this.shortName;
		}
		public void setShortName(String shortName) {
			this.shortName = shortName;
		}
		public String getSuiteCreated() {
			return this.suiteCreated;
		}
		public void setSuiteCreated(String suiteCreated) {
			this.suiteCreated = suiteCreated;
		}
		public Long getSuiteId() {
			return this.suiteId;
		}
		public void setSuiteId(Long suiteId) {
			this.suiteId = suiteId;
		}
		public String getSuiteModified() {
			return this.suiteModified;
		}
		public void setSuiteModified(String suiteModified) {
			this.suiteModified = suiteModified;
		}
		public String getSuiteName() {
			return this.suiteName;
		}
		public void setSuiteName(String suiteName) {
			this.suiteName = suiteName;
		}
		public String getSuiteNo() {
			return this.suiteNo;
		}
		public void setSuiteNo(String suiteNo) {
			this.suiteNo = suiteNo;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}
		public String getWholesalePrice() {
			return this.wholesalePrice;
		}
		public void setWholesalePrice(String wholesalePrice) {
			this.wholesalePrice = wholesalePrice;
		}

}

	/**
 * 货品数据 货品相关数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 货品数据
		 */
		@ApiListField("suite_list")
		@ApiField("suiteList")
		private List<SuiteList> suiteList;
		/**
		 * 总数 查询条件总单据数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<SuiteList> getSuiteList() {
			return this.suiteList;
		}
		public void setSuiteList(List<SuiteList> suiteList) {
			this.suiteList = suiteList;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
