package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.sales.tradequery.queryhistorywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtSalesTradequeryQueryhistorywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2714947776856637163L;

	/** 
	 * 单据数据
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 无错误信息不返回
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码：返回0为正常
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 订单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Detailslist {

	/**
		 * 手工调整价,正数为加价,负数为减价,暂未处理
		 */
		@ApiField("adjust")
		private String adjust;
		/**
		 * 平台货品id
		 */
		@ApiField("api_goods_id")
		private String apiGoodsId;
		/**
		 * 平台货品名称
		 */
		@ApiField("api_goods_name")
		private String apiGoodsName;
		/**
		 * 平台规格id
		 */
		@ApiField("api_spec_id")
		private String apiSpecId;
		/**
		 * 平台规格名
		 */
		@ApiField("api_spec_name")
		private String apiSpecName;
		/**
		 * 佣金
		 */
		@ApiField("commission")
		private String commission;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private Long created;
		/**
		 * 发货条件:  2、    1、款到发货 2、货到付款(包含部分货到付款) 3、分期付款
		 */
		@ApiField("delivery_term")
		private Long deliveryTerm;
		/**
		 * 总折扣金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 订单内部来源: 1、手机 2、聚划算
		 */
		@ApiField("from_mask")
		private Long fromMask;
		/**
		 * 是否是赠品 0、非赠品  1、自动赠送 2、手工赠送
		 */
		@ApiField("gift_type")
		private Long giftType;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编码
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 货品类型
		 */
		@ApiField("goods_type")
		private Long goodsType;
		/**
		 * 退款模式:  1、担保 2、非担保  3、在线非担保
		 */
		@ApiField("guarantee_mode")
		private Long guaranteeMode;
		/**
		 * 图片路径
		 */
		@ApiField("img_url")
		private String imgUrl;
		/**
		 * 修改时间
		 */
		@ApiField("modified")
		private Long modified;
		/**
		 * 货品数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 成交价,原始单折扣及分摊之后的价格
		 */
		@ApiField("order_price")
		private String orderPrice;
		/**
		 * 已支付金额
		 */
		@ApiField("paid")
		private String paid;
		/**
		 * 平台ID
		 */
		@ApiField("platform_id")
		private String platformId;
		/**
		 * 如果没有对应的原始单明细,则返回0。平台状态: 10、未确认 20、待尾款 30、待发货 40、部分发货 50、已发货 60、已签收 70、已完成 80、已退款 90、已关闭
		 */
		@ApiField("platform_status")
		private Long platformStatus;
		/**
		 * 销售单价，手工新建时使用货品属性中的“零售价”
		 */
		@ApiField("price")
		private String price;
		/**
		 * 自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 订单明细唯一键
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 售后退款数量
		 */
		@ApiField("refund_num")
		private String refundNum;
		/**
		 * 退款状态:  0、无退款 1、已取消 2、已申请退款 3、待退款，平台已退款,系统未退款,但订单已审核,不能直接改成,除非驳回 4、等待取消,平台上取消退款,系统已退款,但订单已审核,不能直接改成,除非驳回 5、退款成功 6、未付款关闭，未付款的取消了
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 子单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 分摊后合计应收=share_price*num
		 */
		@ApiField("share_amount")
		private String shareAmount;
		/**
		 * 进入ERP后再次调整的价格，默认值与order_price一致
		 */
		@ApiField("share_price")
		private String sharePrice;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 原始子订单号
		 */
		@ApiField("src_oid")
		private String srcOid;
		/**
		 * 原始订单号
		 */
		@ApiField("src_tid")
		private String srcTid;
		/**
		 * 组合装分摊后总价
		 */
		@ApiField("suite_amount")
		private String suiteAmount;
		/**
		 * 组合装优惠
		 */
		@ApiField("suite_discount")
		private String suiteDiscount;
		/**
		 * 如果是组合装拆分的，此为组合装名称
		 */
		@ApiField("suite_name")
		private String suiteName;
		/**
		 * 组合装商家编码
		 */
		@ApiField("suite_no")
		private String suiteNo;
		/**
		 * 组合装数量,不受拆分合并影响
		 */
		@ApiField("suite_num")
		private String suiteNum;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 订单唯一键
		 */
		@ApiField("trade_id")
		private Long tradeId;
		/**
		 * 子单预估总重量
		 */
		@ApiField("weight")
		private String weight;
	

	public String getAdjust() {
			return this.adjust;
		}
		public void setAdjust(String adjust) {
			this.adjust = adjust;
		}
		public String getApiGoodsId() {
			return this.apiGoodsId;
		}
		public void setApiGoodsId(String apiGoodsId) {
			this.apiGoodsId = apiGoodsId;
		}
		public String getApiGoodsName() {
			return this.apiGoodsName;
		}
		public void setApiGoodsName(String apiGoodsName) {
			this.apiGoodsName = apiGoodsName;
		}
		public String getApiSpecId() {
			return this.apiSpecId;
		}
		public void setApiSpecId(String apiSpecId) {
			this.apiSpecId = apiSpecId;
		}
		public String getApiSpecName() {
			return this.apiSpecName;
		}
		public void setApiSpecName(String apiSpecName) {
			this.apiSpecName = apiSpecName;
		}
		public String getCommission() {
			return this.commission;
		}
		public void setCommission(String commission) {
			this.commission = commission;
		}
		public Long getCreated() {
			return this.created;
		}
		public void setCreated(Long created) {
			this.created = created;
		}
		public Long getDeliveryTerm() {
			return this.deliveryTerm;
		}
		public void setDeliveryTerm(Long deliveryTerm) {
			this.deliveryTerm = deliveryTerm;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public Long getFromMask() {
			return this.fromMask;
		}
		public void setFromMask(Long fromMask) {
			this.fromMask = fromMask;
		}
		public Long getGiftType() {
			return this.giftType;
		}
		public void setGiftType(Long giftType) {
			this.giftType = giftType;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Long getGoodsType() {
			return this.goodsType;
		}
		public void setGoodsType(Long goodsType) {
			this.goodsType = goodsType;
		}
		public Long getGuaranteeMode() {
			return this.guaranteeMode;
		}
		public void setGuaranteeMode(Long guaranteeMode) {
			this.guaranteeMode = guaranteeMode;
		}
		public String getImgUrl() {
			return this.imgUrl;
		}
		public void setImgUrl(String imgUrl) {
			this.imgUrl = imgUrl;
		}
		public Long getModified() {
			return this.modified;
		}
		public void setModified(Long modified) {
			this.modified = modified;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOrderPrice() {
			return this.orderPrice;
		}
		public void setOrderPrice(String orderPrice) {
			this.orderPrice = orderPrice;
		}
		public String getPaid() {
			return this.paid;
		}
		public void setPaid(String paid) {
			this.paid = paid;
		}
		public String getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(String platformId) {
			this.platformId = platformId;
		}
		public Long getPlatformStatus() {
			return this.platformStatus;
		}
		public void setPlatformStatus(Long platformStatus) {
			this.platformStatus = platformStatus;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRefundNum() {
			return this.refundNum;
		}
		public void setRefundNum(String refundNum) {
			this.refundNum = refundNum;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getShareAmount() {
			return this.shareAmount;
		}
		public void setShareAmount(String shareAmount) {
			this.shareAmount = shareAmount;
		}
		public String getSharePrice() {
			return this.sharePrice;
		}
		public void setSharePrice(String sharePrice) {
			this.sharePrice = sharePrice;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getSrcOid() {
			return this.srcOid;
		}
		public void setSrcOid(String srcOid) {
			this.srcOid = srcOid;
		}
		public String getSrcTid() {
			return this.srcTid;
		}
		public void setSrcTid(String srcTid) {
			this.srcTid = srcTid;
		}
		public String getSuiteAmount() {
			return this.suiteAmount;
		}
		public void setSuiteAmount(String suiteAmount) {
			this.suiteAmount = suiteAmount;
		}
		public String getSuiteDiscount() {
			return this.suiteDiscount;
		}
		public void setSuiteDiscount(String suiteDiscount) {
			this.suiteDiscount = suiteDiscount;
		}
		public String getSuiteName() {
			return this.suiteName;
		}
		public void setSuiteName(String suiteName) {
			this.suiteName = suiteName;
		}
		public String getSuiteNo() {
			return this.suiteNo;
		}
		public void setSuiteNo(String suiteNo) {
			this.suiteNo = suiteNo;
		}
		public String getSuiteNum() {
			return this.suiteNum;
		}
		public void setSuiteNum(String suiteNum) {
			this.suiteNum = suiteNum;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public Long getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(Long tradeId) {
			this.tradeId = tradeId;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 异常订单原因（位运算）:  2、修改地址 4、修改发票 8、更换仓库 16、修改备注 32、更换货品 128、拦截赠品 256、拦截换货 512、买家留言变化 1024、拦截平台已发货
		 */
		@ApiField("bad_reason")
		private Long badReason;
		/**
		 * 客户备注
		 */
		@ApiField("buyer_message")
		private String buyerMessage;
		/**
		 * 买家网名, 淘系平台不返回
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 审核员
		 */
		@ApiField("checker_name")
		private String checkerName;
		/**
		 * 签出员
		 */
		@ApiField("checkouter_name")
		private String checkouterName;
		/**
		 * 货到付款金额
		 */
		@ApiField("cod_amount")
		private String codAmount;
		/**
		 * 佣金
		 */
		@ApiField("commission")
		private String commission;
		/**
		 * 发货时间
		 */
		@ApiField("consign_time")
		private String consignTime;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 客服备注
		 */
		@ApiField("cs_remark")
		private String csRemark;
		/**
		 * 币种
		 */
		@ApiField("currency")
		private String currency;
		/**
		 * 买家姓名
		 */
		@ApiField("customer_name")
		private String customerName;
		/**
		 * 客户编码
		 */
		@ApiField("customer_no")
		private String customerNo;
		/**
		 * 预计发货时间
		 */
		@ApiField("delay_to_time")
		private String delayToTime;
		/**
		 * 发货条件:  1、款到发货 2、货到付款(包含部分货到付款) 3、分期付款
		 */
		@ApiField("delivery_term")
		private Long deliveryTerm;
		/**
		 * 订单明细
		 */
		@ApiListField("detail_list")
		@ApiField("detailslist")
		private List<Detailslist> detailList;
		/**
		 * 优惠金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 买家COD费用
		 */
		@ApiField("ext_cod_fee")
		private String extCodFee;
		/**
		 * 财审员
		 */
		@ApiField("fchecker_name")
		private String fcheckerName;
		/**
		 * 分销商名
		 */
		@ApiField("fenxiao_nick")
		private String fenxiaoNick;
		/**
		 * 分销类别:  0、非分销订单 1、代销 2、经销
		 */
		@ApiField("fenxiao_type")
		private Long fenxiaoType;
		/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 冻结原因
		 */
		@ApiField("freeze_reason")
		private String freezeReason;
		/**
		 * 货品总额
		 */
		@ApiField("goods_amount")
		private String goodsAmount;
		/**
		 * 货款预估成本
		 */
		@ApiField("goods_cost")
		private String goodsCost;
		/**
		 * 货品总数
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 货品种类数
		 */
		@ApiField("goods_type_count")
		private String goodsTypeCount;
		/**
		 * 证件号码
		 */
		@ApiField("id_card")
		private String idCard;
		/**
		 * 证件类别
		 */
		@ApiField("id_card_type")
		private Long idCardType;
		/**
		 * 发票内容
		 */
		@ApiField("invoice_content")
		private String invoiceContent;
		/**
		 * 发票ID，目前只设0-1，1表示已开发票
		 */
		@ApiField("invoice_id")
		private Long invoiceId;
		/**
		 * 发票标题
		 */
		@ApiField("invoice_title")
		private String invoiceTitle;
		/**
		 * 发票类别:  0、不需要 1、普通发票 2、普通增值税发票 3、专用增值税发票
		 */
		@ApiField("invoice_type")
		private Long invoiceType;
		/**
		 * 物流公司编号
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 物流ID
		 */
		@ApiField("logistics_id")
		private Long logisticsId;
		/**
		 * 物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流编号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 物流类型
		 */
		@ApiField("logistics_type")
		private Long logisticsType;
		/**
		 * 物流类型
		 */
		@ApiField("logistics_type_name")
		private String logisticsTypeName;
		/**
		 * 修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 其他收费
		 */
		@ApiField("other_amount")
		private String otherAmount;
		/**
		 * 平台支付帐号, 淘系平台不返回
		 */
		@ApiField("pay_account")
		private String payAccount;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private String payTime;
		/**
		 * 平台ID
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 邮费
		 */
		@ApiField("post_amount")
		private String postAmount;
		/**
		 * 预估邮费成本
		 */
		@ApiField("post_cost")
		private String postCost;
		/**
		 * 打印备注
		 */
		@ApiField("print_remark")
		private String printRemark;
		/**
		 * 预估利润
		 */
		@ApiField("profit")
		private String profit;
		/**
		 * 原货品数量
		 */
		@ApiField("raw_goods_count")
		private String rawGoodsCount;
		/**
		 * 原货品种类数
		 */
		@ApiField("raw_goods_type_count")
		private Long rawGoodsTypeCount;
		/**
		 * 应收金额
		 */
		@ApiField("receivable")
		private String receivable;
		/**
		 * 收件人地址, 淘系平台不返回
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 省市区空格分隔
		 */
		@ApiField("receiver_area")
		private String receiverArea;
		/**
		 * 城市id
		 */
		@ApiField("receiver_city")
		private Long receiverCity;
		/**
		 * 地区id
		 */
		@ApiField("receiver_district")
		private Long receiverDistrict;
		/**
		 * 大头笔
		 */
		@ApiField("receiver_dtb")
		private String receiverDtb;
		/**
		 * 手机, 淘系平台不返回
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收货人姓名, 淘系平台不返回
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 省份id
		 */
		@ApiField("receiver_province")
		private Long receiverProvince;
		/**
		 * 京东几环
		 */
		@ApiField("receiver_ring")
		private String receiverRing;
		/**
		 * 固话, 淘系平台不返回
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 邮编
		 */
		@ApiField("receiver_zip")
		private String receiverZip;
		/**
		 * 退款状态:  0、无退款 1、申请退款 2、部分退款 3、全部退款
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 客服备注旗子
		 */
		@ApiField("remark_flag")
		private Long remarkFlag;
		/**
		 * 业务员
		 */
		@ApiField("salesman_name")
		private String salesmanName;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 店铺平台id
		 */
		@ApiField("shop_platform_id")
		private Long shopPlatformId;
		/**
		 * 店铺备注
		 */
		@ApiField("shop_remark")
		private String shopRemark;
		/**
		 * 单一货品商家编码,多种货品为空,组合装时为组合装编码
		 */
		@ApiField("single_spec_no")
		private String singleSpecNo;
		/**
		 * 原始单号，如果有多个，以","分隔，且以增序排列,不重复,过长将被裁剪
		 */
		@ApiField("src_tids")
		private String srcTids;
		/**
		 * 出库单建单时间
		 */
		@ApiField("stock_check_time")
		private String stockCheckTime;
		/**
		 * 出库单号
		 */
		@ApiField("stockout_no")
		private String stockoutNo;
		/**
		 * 子平台id
		 */
		@ApiField("sub_platform_id")
		private Long subPlatformId;
		/**
		 * 税额
		 */
		@ApiField("tax")
		private String tax;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 配送时间,如周一至周五，上午
		 */
		@ApiField("to_deliver_time")
		private String toDeliverTime;
		/**
		 * 订单来源:  1、API抓单 2、手工建单 3、导入 4、复制订单 5、接口推送 6、补发订单 7、PDA选货开单
		 */
		@ApiField("trade_from")
		private Long tradeFrom;
		/**
		 * 订单唯一键
		 */
		@ApiField("trade_id")
		private Long tradeId;
		/**
		 * 订单标签
		 */
		@ApiField("trade_label")
		private String tradeLabel;
		/**
		 * 订单号
		 */
		@ApiField("trade_no")
		private String tradeNo;
		/**
		 * 订单状态，参考请求参数
		 */
		@ApiField("trade_status")
		private Long tradeStatus;
		/**
		 * 下单时间
		 */
		@ApiField("trade_time")
		private String tradeTime;
		/**
		 * 订单类型:  1、网店销售 2、线下订单 3、售后换货 4、批发业务 7、现款销售 8、分销 101、自定义类型一 102、自定义类型二 103、自定义类型三 104、自定义类型四 105、自定义类型五 106、自定义类型六
		 */
		@ApiField("trade_type")
		private Long tradeType;
		/**
		 * 版本号
		 */
		@ApiField("version_id")
		private Long versionId;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
		/**
		 * 仓库类型:  1、普通仓库,大于1为委外仓库(如京东仓储,物流宝等)
		 */
		@ApiField("warehouse_type")
		private Long warehouseType;
		/**
		 * 预估称重kg
		 */
		@ApiField("weight")
		private String weight;
	

	public Long getBadReason() {
			return this.badReason;
		}
		public void setBadReason(Long badReason) {
			this.badReason = badReason;
		}
		public String getBuyerMessage() {
			return this.buyerMessage;
		}
		public void setBuyerMessage(String buyerMessage) {
			this.buyerMessage = buyerMessage;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getCheckerName() {
			return this.checkerName;
		}
		public void setCheckerName(String checkerName) {
			this.checkerName = checkerName;
		}
		public String getCheckouterName() {
			return this.checkouterName;
		}
		public void setCheckouterName(String checkouterName) {
			this.checkouterName = checkouterName;
		}
		public String getCodAmount() {
			return this.codAmount;
		}
		public void setCodAmount(String codAmount) {
			this.codAmount = codAmount;
		}
		public String getCommission() {
			return this.commission;
		}
		public void setCommission(String commission) {
			this.commission = commission;
		}
		public String getConsignTime() {
			return this.consignTime;
		}
		public void setConsignTime(String consignTime) {
			this.consignTime = consignTime;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getCsRemark() {
			return this.csRemark;
		}
		public void setCsRemark(String csRemark) {
			this.csRemark = csRemark;
		}
		public String getCurrency() {
			return this.currency;
		}
		public void setCurrency(String currency) {
			this.currency = currency;
		}
		public String getCustomerName() {
			return this.customerName;
		}
		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}
		public String getCustomerNo() {
			return this.customerNo;
		}
		public void setCustomerNo(String customerNo) {
			this.customerNo = customerNo;
		}
		public String getDelayToTime() {
			return this.delayToTime;
		}
		public void setDelayToTime(String delayToTime) {
			this.delayToTime = delayToTime;
		}
		public Long getDeliveryTerm() {
			return this.deliveryTerm;
		}
		public void setDeliveryTerm(Long deliveryTerm) {
			this.deliveryTerm = deliveryTerm;
		}
		public List<Detailslist> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<Detailslist> detailList) {
			this.detailList = detailList;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getExtCodFee() {
			return this.extCodFee;
		}
		public void setExtCodFee(String extCodFee) {
			this.extCodFee = extCodFee;
		}
		public String getFcheckerName() {
			return this.fcheckerName;
		}
		public void setFcheckerName(String fcheckerName) {
			this.fcheckerName = fcheckerName;
		}
		public String getFenxiaoNick() {
			return this.fenxiaoNick;
		}
		public void setFenxiaoNick(String fenxiaoNick) {
			this.fenxiaoNick = fenxiaoNick;
		}
		public Long getFenxiaoType() {
			return this.fenxiaoType;
		}
		public void setFenxiaoType(Long fenxiaoType) {
			this.fenxiaoType = fenxiaoType;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getFreezeReason() {
			return this.freezeReason;
		}
		public void setFreezeReason(String freezeReason) {
			this.freezeReason = freezeReason;
		}
		public String getGoodsAmount() {
			return this.goodsAmount;
		}
		public void setGoodsAmount(String goodsAmount) {
			this.goodsAmount = goodsAmount;
		}
		public String getGoodsCost() {
			return this.goodsCost;
		}
		public void setGoodsCost(String goodsCost) {
			this.goodsCost = goodsCost;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getGoodsTypeCount() {
			return this.goodsTypeCount;
		}
		public void setGoodsTypeCount(String goodsTypeCount) {
			this.goodsTypeCount = goodsTypeCount;
		}
		public String getIdCard() {
			return this.idCard;
		}
		public void setIdCard(String idCard) {
			this.idCard = idCard;
		}
		public Long getIdCardType() {
			return this.idCardType;
		}
		public void setIdCardType(Long idCardType) {
			this.idCardType = idCardType;
		}
		public String getInvoiceContent() {
			return this.invoiceContent;
		}
		public void setInvoiceContent(String invoiceContent) {
			this.invoiceContent = invoiceContent;
		}
		public Long getInvoiceId() {
			return this.invoiceId;
		}
		public void setInvoiceId(Long invoiceId) {
			this.invoiceId = invoiceId;
		}
		public String getInvoiceTitle() {
			return this.invoiceTitle;
		}
		public void setInvoiceTitle(String invoiceTitle) {
			this.invoiceTitle = invoiceTitle;
		}
		public Long getInvoiceType() {
			return this.invoiceType;
		}
		public void setInvoiceType(Long invoiceType) {
			this.invoiceType = invoiceType;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public Long getLogisticsId() {
			return this.logisticsId;
		}
		public void setLogisticsId(Long logisticsId) {
			this.logisticsId = logisticsId;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public Long getLogisticsType() {
			return this.logisticsType;
		}
		public void setLogisticsType(Long logisticsType) {
			this.logisticsType = logisticsType;
		}
		public String getLogisticsTypeName() {
			return this.logisticsTypeName;
		}
		public void setLogisticsTypeName(String logisticsTypeName) {
			this.logisticsTypeName = logisticsTypeName;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getOtherAmount() {
			return this.otherAmount;
		}
		public void setOtherAmount(String otherAmount) {
			this.otherAmount = otherAmount;
		}
		public String getPayAccount() {
			return this.payAccount;
		}
		public void setPayAccount(String payAccount) {
			this.payAccount = payAccount;
		}
		public String getPayTime() {
			return this.payTime;
		}
		public void setPayTime(String payTime) {
			this.payTime = payTime;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public String getPostAmount() {
			return this.postAmount;
		}
		public void setPostAmount(String postAmount) {
			this.postAmount = postAmount;
		}
		public String getPostCost() {
			return this.postCost;
		}
		public void setPostCost(String postCost) {
			this.postCost = postCost;
		}
		public String getPrintRemark() {
			return this.printRemark;
		}
		public void setPrintRemark(String printRemark) {
			this.printRemark = printRemark;
		}
		public String getProfit() {
			return this.profit;
		}
		public void setProfit(String profit) {
			this.profit = profit;
		}
		public String getRawGoodsCount() {
			return this.rawGoodsCount;
		}
		public void setRawGoodsCount(String rawGoodsCount) {
			this.rawGoodsCount = rawGoodsCount;
		}
		public Long getRawGoodsTypeCount() {
			return this.rawGoodsTypeCount;
		}
		public void setRawGoodsTypeCount(Long rawGoodsTypeCount) {
			this.rawGoodsTypeCount = rawGoodsTypeCount;
		}
		public String getReceivable() {
			return this.receivable;
		}
		public void setReceivable(String receivable) {
			this.receivable = receivable;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public String getReceiverArea() {
			return this.receiverArea;
		}
		public void setReceiverArea(String receiverArea) {
			this.receiverArea = receiverArea;
		}
		public Long getReceiverCity() {
			return this.receiverCity;
		}
		public void setReceiverCity(Long receiverCity) {
			this.receiverCity = receiverCity;
		}
		public Long getReceiverDistrict() {
			return this.receiverDistrict;
		}
		public void setReceiverDistrict(Long receiverDistrict) {
			this.receiverDistrict = receiverDistrict;
		}
		public String getReceiverDtb() {
			return this.receiverDtb;
		}
		public void setReceiverDtb(String receiverDtb) {
			this.receiverDtb = receiverDtb;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public Long getReceiverProvince() {
			return this.receiverProvince;
		}
		public void setReceiverProvince(Long receiverProvince) {
			this.receiverProvince = receiverProvince;
		}
		public String getReceiverRing() {
			return this.receiverRing;
		}
		public void setReceiverRing(String receiverRing) {
			this.receiverRing = receiverRing;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public String getReceiverZip() {
			return this.receiverZip;
		}
		public void setReceiverZip(String receiverZip) {
			this.receiverZip = receiverZip;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public Long getRemarkFlag() {
			return this.remarkFlag;
		}
		public void setRemarkFlag(Long remarkFlag) {
			this.remarkFlag = remarkFlag;
		}
		public String getSalesmanName() {
			return this.salesmanName;
		}
		public void setSalesmanName(String salesmanName) {
			this.salesmanName = salesmanName;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public Long getShopPlatformId() {
			return this.shopPlatformId;
		}
		public void setShopPlatformId(Long shopPlatformId) {
			this.shopPlatformId = shopPlatformId;
		}
		public String getShopRemark() {
			return this.shopRemark;
		}
		public void setShopRemark(String shopRemark) {
			this.shopRemark = shopRemark;
		}
		public String getSingleSpecNo() {
			return this.singleSpecNo;
		}
		public void setSingleSpecNo(String singleSpecNo) {
			this.singleSpecNo = singleSpecNo;
		}
		public String getSrcTids() {
			return this.srcTids;
		}
		public void setSrcTids(String srcTids) {
			this.srcTids = srcTids;
		}
		public String getStockCheckTime() {
			return this.stockCheckTime;
		}
		public void setStockCheckTime(String stockCheckTime) {
			this.stockCheckTime = stockCheckTime;
		}
		public String getStockoutNo() {
			return this.stockoutNo;
		}
		public void setStockoutNo(String stockoutNo) {
			this.stockoutNo = stockoutNo;
		}
		public Long getSubPlatformId() {
			return this.subPlatformId;
		}
		public void setSubPlatformId(Long subPlatformId) {
			this.subPlatformId = subPlatformId;
		}
		public String getTax() {
			return this.tax;
		}
		public void setTax(String tax) {
			this.tax = tax;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getToDeliverTime() {
			return this.toDeliverTime;
		}
		public void setToDeliverTime(String toDeliverTime) {
			this.toDeliverTime = toDeliverTime;
		}
		public Long getTradeFrom() {
			return this.tradeFrom;
		}
		public void setTradeFrom(Long tradeFrom) {
			this.tradeFrom = tradeFrom;
		}
		public Long getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(Long tradeId) {
			this.tradeId = tradeId;
		}
		public String getTradeLabel() {
			return this.tradeLabel;
		}
		public void setTradeLabel(String tradeLabel) {
			this.tradeLabel = tradeLabel;
		}
		public String getTradeNo() {
			return this.tradeNo;
		}
		public void setTradeNo(String tradeNo) {
			this.tradeNo = tradeNo;
		}
		public Long getTradeStatus() {
			return this.tradeStatus;
		}
		public void setTradeStatus(Long tradeStatus) {
			this.tradeStatus = tradeStatus;
		}
		public String getTradeTime() {
			return this.tradeTime;
		}
		public void setTradeTime(String tradeTime) {
			this.tradeTime = tradeTime;
		}
		public Long getTradeType() {
			return this.tradeType;
		}
		public void setTradeType(Long tradeType) {
			this.tradeType = tradeType;
		}
		public Long getVersionId() {
			return this.versionId;
		}
		public void setVersionId(Long versionId) {
			this.versionId = versionId;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}
		public Long getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(Long warehouseType) {
			this.warehouseType = warehouseType;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
