package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.extstockout.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsExtstockoutSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6339933477723524277L;

	/** 
	 * 单据数据
	 */
	@ApiField("data")
	private Data data;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}
	
	/**
 * 出库单详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailList {

	/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 审核时成本价
		 */
		@ApiField("checked_post_price")
		private String checkedPostPrice;
		/**
		 * 分类名称
		 */
		@ApiField("class_name")
		private String className;
		/**
		 * 总折扣金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 是否赠品（0非赠品 1自动赠送 2手工赠送）
		 */
		@ApiField("gift_type")
		private Long giftType;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 是否包装物
		 */
		@ApiField("is_package")
		private Boolean isPackage;
		/**
		 * 市场价
		 */
		@ApiField("market_price")
		private String marketPrice;
		/**
		 * 出库数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 成交价格
		 */
		@ApiField("order_price")
		private String orderPrice;
		/**
		 * 平台支付订单ID
		 */
		@ApiField("pay_id")
		private String payId;
		/**
		 * 支付方式（1在线转帐 2现金，3银行转账，4邮局汇款 5预付款 6刷卡）
		 */
		@ApiField("pay_method")
		private String payMethod;
		/**
		 * 供应商货品编号
		 */
		@ApiField("provider_goods_no")
		private String providerGoodsNo;
		/**
		 * 出库单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 退货总金额
		 */
		@ApiField("ret_amount")
		private String retAmount;
		/**
		 * 折扣
		 */
		@ApiField("ret_discount")
		private String retDiscount;
		/**
		 * 退货数量
		 */
		@ApiField("ret_num")
		private String retNum;
		/**
		 * 退货出库金额
		 */
		@ApiField("ret_out_amount")
		private String retOutAmount;
		/**
		 * 退货出库数量
		 */
		@ApiField("ret_out_num")
		private String retOutNum;
		/**
		 * 退货价格
		 */
		@ApiField("ret_price")
		private String retPrice;
		/**
		 * 退货货品备注
		 */
		@ApiField("ret_remark")
		private String retRemark;
		/**
		 * 售价
		 */
		@ApiField("sell_price")
		private String sellPrice;
		/**
		 * 规格编码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 原始订单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 单位名称
		 */
		@ApiField("unit_name")
		private String unitName;
		/**
		 * 单位系数
		 */
		@ApiField("unit_ratio")
		private String unitRatio;
	

	public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getCheckedPostPrice() {
			return this.checkedPostPrice;
		}
		public void setCheckedPostPrice(String checkedPostPrice) {
			this.checkedPostPrice = checkedPostPrice;
		}
		public String getClassName() {
			return this.className;
		}
		public void setClassName(String className) {
			this.className = className;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public Long getGiftType() {
			return this.giftType;
		}
		public void setGiftType(Long giftType) {
			this.giftType = giftType;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Boolean getIsPackage() {
			return this.isPackage;
		}
		public void setIsPackage(Boolean isPackage) {
			this.isPackage = isPackage;
		}
		public String getMarketPrice() {
			return this.marketPrice;
		}
		public void setMarketPrice(String marketPrice) {
			this.marketPrice = marketPrice;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOrderPrice() {
			return this.orderPrice;
		}
		public void setOrderPrice(String orderPrice) {
			this.orderPrice = orderPrice;
		}
		public String getPayId() {
			return this.payId;
		}
		public void setPayId(String payId) {
			this.payId = payId;
		}
		public String getPayMethod() {
			return this.payMethod;
		}
		public void setPayMethod(String payMethod) {
			this.payMethod = payMethod;
		}
		public String getProviderGoodsNo() {
			return this.providerGoodsNo;
		}
		public void setProviderGoodsNo(String providerGoodsNo) {
			this.providerGoodsNo = providerGoodsNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getRetAmount() {
			return this.retAmount;
		}
		public void setRetAmount(String retAmount) {
			this.retAmount = retAmount;
		}
		public String getRetDiscount() {
			return this.retDiscount;
		}
		public void setRetDiscount(String retDiscount) {
			this.retDiscount = retDiscount;
		}
		public String getRetNum() {
			return this.retNum;
		}
		public void setRetNum(String retNum) {
			this.retNum = retNum;
		}
		public String getRetOutAmount() {
			return this.retOutAmount;
		}
		public void setRetOutAmount(String retOutAmount) {
			this.retOutAmount = retOutAmount;
		}
		public String getRetOutNum() {
			return this.retOutNum;
		}
		public void setRetOutNum(String retOutNum) {
			this.retOutNum = retOutNum;
		}
		public String getRetPrice() {
			return this.retPrice;
		}
		public void setRetPrice(String retPrice) {
			this.retPrice = retPrice;
		}
		public String getRetRemark() {
			return this.retRemark;
		}
		public void setRetRemark(String retRemark) {
			this.retRemark = retRemark;
		}
		public String getSellPrice() {
			return this.sellPrice;
		}
		public void setSellPrice(String sellPrice) {
			this.sellPrice = sellPrice;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}
		public String getUnitRatio() {
			return this.unitRatio;
		}
		public void setUnitRatio(String unitRatio) {
			this.unitRatio = unitRatio;
		}

}

	/**
 * 单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 买家留言
		 */
		@ApiField("buyer_message")
		private String buyerMessage;
		/**
		 * calc_post_cost
		 */
		@ApiField("calc_post_cost")
		private String calcPostCost;
		/**
		 * 审核时总成本
		 */
		@ApiField("checked_goods_total_cost")
		private String checkedGoodsTotalCost;
		/**
		 * 发货时间
		 */
		@ApiField("consign_time")
		private String consignTime;
		/**
		 * 创建时间
		 */
		@ApiField("create_time")
		private String createTime;
		/**
		 * 客服备注
		 */
		@ApiField("cs_remark")
		private String csRemark;
		/**
		 * 出库单详情
		 */
		@ApiListField("detail_list")
		@ApiField("detailList")
		private List<DetailList> detailList;
		/**
		 * 客服备注旗标
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 发票内容
		 */
		@ApiField("invoice_content")
		private String invoiceContent;
		/**
		 * 发票抬头
		 */
		@ApiField("invoice_title")
		private String invoiceTitle;
		/**
		 * 发票类型（0不需要1普通发票2增值税发票）
		 */
		@ApiField("invoice_type")
		private Long invoiceType;
		/**
		 * 物流编号
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 修改时间
		 */
		@ApiField("modified_time")
		private String modifiedTime;
		/**
		 * 买家昵称
		 */
		@ApiField("nick_name")
		private String nickName;
		/**
		 * 成交价格
		 */
		@ApiField("order_price")
		private String orderPrice;
		/**
		 * 单据类型名称
		 */
		@ApiField("order_type_name")
		private String orderTypeName;
		/**
		 * 包装费用
		 */
		@ApiField("package_fee")
		private String packageFee;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private String payTime;
		/**
		 * 平台名称
		 */
		@ApiField("platform_name")
		private String platformName;
		/**
		 * 邮费
		 */
		@ApiField("post_fee")
		private String postFee;
		/**
		 * 供应商名称
		 */
		@ApiField("provider_name")
		private String providerName;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 原货品数量
		 */
		@ApiField("raw_goods_count")
		private String rawGoodsCount;
		/**
		 * 出库原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 收件人地址
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 收件人省市区
		 */
		@ApiField("receiver_area")
		private String receiverArea;
		/**
		 * 收件人手机
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 收件人电话
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 收件人邮编
		 */
		@ApiField("receiver_zip")
		private String receiverZip;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 退货单审核时间
		 */
		@ApiField("ret_check_time")
		private String retCheckTime;
		/**
		 * 供应商联系人姓名
		 */
		@ApiField("ret_contact")
		private String retContact;
		/**
		 * 退货数量
		 */
		@ApiField("ret_goods_count")
		private String retGoodsCount;
		/**
		 * 退货货品总价
		 */
		@ApiField("ret_goods_fee")
		private String retGoodsFee;
		/**
		 * 退货出库数量
		 */
		@ApiField("ret_goods_out_count")
		private String retGoodsOutCount;
		/**
		 * 退货货品种类数
		 */
		@ApiField("ret_goods_type_count")
		private String retGoodsTypeCount;
		/**
		 * 退货物流方式
		 */
		@ApiField("ret_logistics_type")
		private String retLogisticsType;
		/**
		 * 退货其他费用
		 */
		@ApiField("ret_other_fee")
		private String retOtherFee;
		/**
		 * 退货运费
		 */
		@ApiField("ret_post_fee")
		private String retPostFee;
		/**
		 * 退货采购单号
		 */
		@ApiField("ret_purchase_no")
		private String retPurchaseNo;
		/**
		 * 退货地址
		 */
		@ApiField("ret_receive_address")
		private String retReceiveAddress;
		/**
		 * 退货单备注
		 */
		@ApiField("ret_remark")
		private String retRemark;
		/**
		 * 退货单状态（10:已取消;20:编辑中;30:待审核;40已审核;60:已完成）
		 */
		@ApiField("ret_status")
		private Long retStatus;
		/**
		 * 供应商联系人电话
		 */
		@ApiField("ret_telno")
		private String retTelno;
		/**
		 * 退货仓库编号
		 */
		@ApiField("ret_warehouse_no")
		private String retWarehouseNo;
		/**
		 * 退货单号
		 */
		@ApiField("return_no")
		private String returnNo;
		/**
		 * 未知发货成本
		 */
		@ApiField("send_unknown_goods_amount")
		private String sendUnknownGoodsAmount;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 源单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 原始单号
		 */
		@ApiField("src_trade_no")
		private String srcTradeNo;
		/**
		 * 出库单状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 出库单号
		 */
		@ApiField("stockout_no")
		private String stockoutNo;
		/**
		 * 优惠金额
		 */
		@ApiField("tra_discount")
		private String traDiscount;
		/**
		 * 分销商
		 */
		@ApiField("tra_fenxiao_nick")
		private String traFenxiaoNick;
		/**
		 * 货品总额
		 */
		@ApiField("tra_goods_amount")
		private String traGoodsAmount;
		/**
		 * 货品数量
		 */
		@ApiField("tra_goods_count")
		private String traGoodsCount;
		/**
		 * 订单修改时间
		 */
		@ApiField("tra_modified_time")
		private String traModifiedTime;
		/**
		 * 邮费
		 */
		@ApiField("tra_post_fee")
		private String traPostFee;
		/**
		 * 应收金额
		 */
		@ApiField("tra_receivable")
		private String traReceivable;
		/**
		 * 订单编号
		 */
		@ApiField("trade_no")
		private String tradeNo;
		/**
		 * 下单时间
		 */
		@ApiField("trade_time")
		private String tradeTime;
		/**
		 * 订单类型（1网店销售2线下零售3售后换货4批发业务）
		 */
		@ApiField("trade_type")
		private Long tradeType;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getBuyerMessage() {
			return this.buyerMessage;
		}
		public void setBuyerMessage(String buyerMessage) {
			this.buyerMessage = buyerMessage;
		}
		public String getCalcPostCost() {
			return this.calcPostCost;
		}
		public void setCalcPostCost(String calcPostCost) {
			this.calcPostCost = calcPostCost;
		}
		public String getCheckedGoodsTotalCost() {
			return this.checkedGoodsTotalCost;
		}
		public void setCheckedGoodsTotalCost(String checkedGoodsTotalCost) {
			this.checkedGoodsTotalCost = checkedGoodsTotalCost;
		}
		public String getConsignTime() {
			return this.consignTime;
		}
		public void setConsignTime(String consignTime) {
			this.consignTime = consignTime;
		}
		public String getCreateTime() {
			return this.createTime;
		}
		public void setCreateTime(String createTime) {
			this.createTime = createTime;
		}
		public String getCsRemark() {
			return this.csRemark;
		}
		public void setCsRemark(String csRemark) {
			this.csRemark = csRemark;
		}
		public List<DetailList> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<DetailList> detailList) {
			this.detailList = detailList;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getInvoiceContent() {
			return this.invoiceContent;
		}
		public void setInvoiceContent(String invoiceContent) {
			this.invoiceContent = invoiceContent;
		}
		public String getInvoiceTitle() {
			return this.invoiceTitle;
		}
		public void setInvoiceTitle(String invoiceTitle) {
			this.invoiceTitle = invoiceTitle;
		}
		public Long getInvoiceType() {
			return this.invoiceType;
		}
		public void setInvoiceType(Long invoiceType) {
			this.invoiceType = invoiceType;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getModifiedTime() {
			return this.modifiedTime;
		}
		public void setModifiedTime(String modifiedTime) {
			this.modifiedTime = modifiedTime;
		}
		public String getNickName() {
			return this.nickName;
		}
		public void setNickName(String nickName) {
			this.nickName = nickName;
		}
		public String getOrderPrice() {
			return this.orderPrice;
		}
		public void setOrderPrice(String orderPrice) {
			this.orderPrice = orderPrice;
		}
		public String getOrderTypeName() {
			return this.orderTypeName;
		}
		public void setOrderTypeName(String orderTypeName) {
			this.orderTypeName = orderTypeName;
		}
		public String getPackageFee() {
			return this.packageFee;
		}
		public void setPackageFee(String packageFee) {
			this.packageFee = packageFee;
		}
		public String getPayTime() {
			return this.payTime;
		}
		public void setPayTime(String payTime) {
			this.payTime = payTime;
		}
		public String getPlatformName() {
			return this.platformName;
		}
		public void setPlatformName(String platformName) {
			this.platformName = platformName;
		}
		public String getPostFee() {
			return this.postFee;
		}
		public void setPostFee(String postFee) {
			this.postFee = postFee;
		}
		public String getProviderName() {
			return this.providerName;
		}
		public void setProviderName(String providerName) {
			this.providerName = providerName;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public String getRawGoodsCount() {
			return this.rawGoodsCount;
		}
		public void setRawGoodsCount(String rawGoodsCount) {
			this.rawGoodsCount = rawGoodsCount;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public String getReceiverArea() {
			return this.receiverArea;
		}
		public void setReceiverArea(String receiverArea) {
			this.receiverArea = receiverArea;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public String getReceiverZip() {
			return this.receiverZip;
		}
		public void setReceiverZip(String receiverZip) {
			this.receiverZip = receiverZip;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getRetCheckTime() {
			return this.retCheckTime;
		}
		public void setRetCheckTime(String retCheckTime) {
			this.retCheckTime = retCheckTime;
		}
		public String getRetContact() {
			return this.retContact;
		}
		public void setRetContact(String retContact) {
			this.retContact = retContact;
		}
		public String getRetGoodsCount() {
			return this.retGoodsCount;
		}
		public void setRetGoodsCount(String retGoodsCount) {
			this.retGoodsCount = retGoodsCount;
		}
		public String getRetGoodsFee() {
			return this.retGoodsFee;
		}
		public void setRetGoodsFee(String retGoodsFee) {
			this.retGoodsFee = retGoodsFee;
		}
		public String getRetGoodsOutCount() {
			return this.retGoodsOutCount;
		}
		public void setRetGoodsOutCount(String retGoodsOutCount) {
			this.retGoodsOutCount = retGoodsOutCount;
		}
		public String getRetGoodsTypeCount() {
			return this.retGoodsTypeCount;
		}
		public void setRetGoodsTypeCount(String retGoodsTypeCount) {
			this.retGoodsTypeCount = retGoodsTypeCount;
		}
		public String getRetLogisticsType() {
			return this.retLogisticsType;
		}
		public void setRetLogisticsType(String retLogisticsType) {
			this.retLogisticsType = retLogisticsType;
		}
		public String getRetOtherFee() {
			return this.retOtherFee;
		}
		public void setRetOtherFee(String retOtherFee) {
			this.retOtherFee = retOtherFee;
		}
		public String getRetPostFee() {
			return this.retPostFee;
		}
		public void setRetPostFee(String retPostFee) {
			this.retPostFee = retPostFee;
		}
		public String getRetPurchaseNo() {
			return this.retPurchaseNo;
		}
		public void setRetPurchaseNo(String retPurchaseNo) {
			this.retPurchaseNo = retPurchaseNo;
		}
		public String getRetReceiveAddress() {
			return this.retReceiveAddress;
		}
		public void setRetReceiveAddress(String retReceiveAddress) {
			this.retReceiveAddress = retReceiveAddress;
		}
		public String getRetRemark() {
			return this.retRemark;
		}
		public void setRetRemark(String retRemark) {
			this.retRemark = retRemark;
		}
		public Long getRetStatus() {
			return this.retStatus;
		}
		public void setRetStatus(Long retStatus) {
			this.retStatus = retStatus;
		}
		public String getRetTelno() {
			return this.retTelno;
		}
		public void setRetTelno(String retTelno) {
			this.retTelno = retTelno;
		}
		public String getRetWarehouseNo() {
			return this.retWarehouseNo;
		}
		public void setRetWarehouseNo(String retWarehouseNo) {
			this.retWarehouseNo = retWarehouseNo;
		}
		public String getReturnNo() {
			return this.returnNo;
		}
		public void setReturnNo(String returnNo) {
			this.returnNo = returnNo;
		}
		public String getSendUnknownGoodsAmount() {
			return this.sendUnknownGoodsAmount;
		}
		public void setSendUnknownGoodsAmount(String sendUnknownGoodsAmount) {
			this.sendUnknownGoodsAmount = sendUnknownGoodsAmount;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public String getSrcTradeNo() {
			return this.srcTradeNo;
		}
		public void setSrcTradeNo(String srcTradeNo) {
			this.srcTradeNo = srcTradeNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getStockoutNo() {
			return this.stockoutNo;
		}
		public void setStockoutNo(String stockoutNo) {
			this.stockoutNo = stockoutNo;
		}
		public String getTraDiscount() {
			return this.traDiscount;
		}
		public void setTraDiscount(String traDiscount) {
			this.traDiscount = traDiscount;
		}
		public String getTraFenxiaoNick() {
			return this.traFenxiaoNick;
		}
		public void setTraFenxiaoNick(String traFenxiaoNick) {
			this.traFenxiaoNick = traFenxiaoNick;
		}
		public String getTraGoodsAmount() {
			return this.traGoodsAmount;
		}
		public void setTraGoodsAmount(String traGoodsAmount) {
			this.traGoodsAmount = traGoodsAmount;
		}
		public String getTraGoodsCount() {
			return this.traGoodsCount;
		}
		public void setTraGoodsCount(String traGoodsCount) {
			this.traGoodsCount = traGoodsCount;
		}
		public String getTraModifiedTime() {
			return this.traModifiedTime;
		}
		public void setTraModifiedTime(String traModifiedTime) {
			this.traModifiedTime = traModifiedTime;
		}
		public String getTraPostFee() {
			return this.traPostFee;
		}
		public void setTraPostFee(String traPostFee) {
			this.traPostFee = traPostFee;
		}
		public String getTraReceivable() {
			return this.traReceivable;
		}
		public void setTraReceivable(String traReceivable) {
			this.traReceivable = traReceivable;
		}
		public String getTradeNo() {
			return this.tradeNo;
		}
		public void setTradeNo(String tradeNo) {
			this.tradeNo = tradeNo;
		}
		public String getTradeTime() {
			return this.tradeTime;
		}
		public void setTradeTime(String tradeTime) {
			this.tradeTime = tradeTime;
		}
		public Long getTradeType() {
			return this.tradeType;
		}
		public void setTradeType(Long tradeType) {
			this.tradeType = tradeType;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据信息
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 数据总条数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
